/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.utils;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ClipboardUtils {
    private static Clipboard clipboard = null;

    private ClipboardUtils() {
    }

    @Nonnull
    public static Clipboard getClipboard() {
        if (clipboard == null) {
            try {
                clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (SecurityException e) {
                clipboard = new Clipboard("sandbox");
            }
        }
        return clipboard;
    }

    public static void pasteImage(Image image) {
        TransferableImage trans = new TransferableImage(image);
        ClipboardUtils.getClipboard().setContents(trans, trans);
    }

    @ParametersAreNonnullByDefault
    private static class TransferableImage
    implements Transferable,
    ClipboardOwner {
        Image image;

        public TransferableImage(Image image) {
            this.image = image;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.imageFlavor) && this.image != null) {
                return this.image;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        @Nonnull
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors;
            for (DataFlavor flavor1 : flavors = this.getTransferDataFlavors()) {
                if (!flavor.equals(flavor1)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }
}

