/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.inspector.options.gui;

import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.exbin.framework.bined.inspector.options.impl.DataInspectorOptionsImpl;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class DataInspectorOptionsPanel
extends JPanel
implements OptionsComponent<DataInspectorOptionsImpl> {
    private OptionsModifiedListener optionsModifiedListener;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(DataInspectorOptionsPanel.class);
    private JCheckBox showParsingPanelCheckBox;

    public DataInspectorOptionsPanel() {
        this.initComponents();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void loadFromOptions(DataInspectorOptionsImpl options) {
        this.showParsingPanelCheckBox.setSelected(options.isShowParsingPanel());
    }

    public void saveToOptions(DataInspectorOptionsImpl options) {
        options.setShowParsingPanel(this.showParsingPanelCheckBox.isSelected());
    }

    private void initComponents() {
        this.showParsingPanelCheckBox = new JCheckBox();
        this.setName("Form");
        this.showParsingPanelCheckBox.setSelected(true);
        this.showParsingPanelCheckBox.setText(this.resourceBundle.getString("showParsingPanelCheckBox.text"));
        this.showParsingPanelCheckBox.setName("showParsingPanelCheckBox");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.showParsingPanelCheckBox, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.showParsingPanelCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new DataInspectorOptionsPanel());
    }

    private void setModified(boolean modified) {
        if (this.optionsModifiedListener != null) {
            this.optionsModifiedListener.wasModified();
        }
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
        this.optionsModifiedListener = listener;
    }
}

