/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.inspector;

import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.action.api.MenuGroup;
import org.exbin.framework.action.api.MenuPosition;
import org.exbin.framework.action.api.PositionMode;
import org.exbin.framework.action.api.SeparationMode;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.api.XBApplicationModule;
import org.exbin.framework.api.XBModuleRepositoryUtils;
import org.exbin.framework.bined.BinEdCodeAreaPainter;
import org.exbin.framework.bined.BinEdFileManager;
import org.exbin.framework.bined.BinedModule;
import org.exbin.framework.bined.gui.BinEdComponentPanel;
import org.exbin.framework.bined.inspector.BasicValuesPositionColorModifier;
import org.exbin.framework.bined.inspector.BinEdComponentInspector;
import org.exbin.framework.bined.inspector.action.ShowParsingPanelAction;
import org.exbin.framework.bined.inspector.options.gui.DataInspectorOptionsPanel;
import org.exbin.framework.bined.inspector.options.impl.DataInspectorOptionsImpl;
import org.exbin.framework.bined.inspector.preferences.DataInspectorPreferences;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.options.api.DefaultOptionsPage;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModuleApi;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.xbup.plugin.XBModuleHandler;

@ParametersAreNonnullByDefault
public class BinedInspectorModule
implements XBApplicationModule {
    public static final String MODULE_ID = XBModuleRepositoryUtils.getModuleIdByApi(BinedInspectorModule.class);
    private static final String VIEW_PARSING_PANEL_MENU_GROUP_ID = MODULE_ID + ".viewParsingPanelMenuGroup";
    private ResourceBundle resourceBundle = null;
    private XBApplication application;
    private EditorProvider editorProvider;
    private BasicValuesPositionColorModifier basicValuesColorModifier = new BasicValuesPositionColorModifier();
    private ShowParsingPanelAction showParsingPanelAction;
    private DefaultOptionsPage<DataInspectorOptionsImpl> dataInspectorOptionsPage;

    public void init(XBModuleHandler application) {
        this.application = (XBApplication)application;
    }

    public void setEditorProvider(EditorProvider editorProvider) {
        this.editorProvider = editorProvider;
        BinedModule binedModule = (BinedModule)this.application.getModuleRepository().getModuleByInterface(BinedModule.class);
        BinEdFileManager fileManager = binedModule.getFileManager();
        fileManager.addPainterColorModifier((BinEdCodeAreaPainter.PositionColorModifier)this.basicValuesColorModifier);
        fileManager.addActionStatusUpdateListener(this::updateActionStatus);
        fileManager.addBinEdComponentExtension(new BinEdFileManager.BinEdFileExtension(){

            @Nonnull
            public Optional<BinEdComponentPanel.BinEdComponentExtension> createComponentExtension(BinEdComponentPanel component) {
                BinEdComponentInspector binEdComponentInspector = new BinEdComponentInspector();
                binEdComponentInspector.setBasicValuesColorModifier(BinedInspectorModule.this.basicValuesColorModifier);
                return Optional.of(binEdComponentInspector);
            }
        });
    }

    public void unregisterModule(String moduleId) {
    }

    public void updateActionStatus(@Nullable CodeAreaCore codeArea) {
        if (this.showParsingPanelAction != null) {
            this.showParsingPanelAction.updateForActiveFile();
        }
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = LanguageUtils.getResourceBundleByClass(BinedInspectorModule.class);
        }
        return this.resourceBundle;
    }

    @Nonnull
    public EditorProvider getEditorProvider() {
        return Objects.requireNonNull(this.editorProvider, "Editor provider was not yet initialized");
    }

    private void ensureSetup() {
        if (this.editorProvider == null) {
            this.getEditorProvider();
        }
        if (this.resourceBundle == null) {
            this.getResourceBundle();
        }
    }

    @Nonnull
    public ShowParsingPanelAction getShowParsingPanelAction() {
        if (this.showParsingPanelAction == null) {
            this.ensureSetup();
            this.showParsingPanelAction = new ShowParsingPanelAction();
            this.showParsingPanelAction.setup(this.application, this.editorProvider, this.resourceBundle);
        }
        return this.showParsingPanelAction;
    }

    public void registerViewValuesPanelMenuActions() {
        ActionModuleApi actionModule = (ActionModuleApi)this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
        actionModule.registerMenuGroup(FrameModuleApi.VIEW_MENU_ID, new MenuGroup(VIEW_PARSING_PANEL_MENU_GROUP_ID, new MenuPosition(PositionMode.BOTTOM), SeparationMode.NONE));
        actionModule.registerMenuItem(FrameModuleApi.VIEW_MENU_ID, MODULE_ID, (Action)this.getShowParsingPanelAction(), new MenuPosition(VIEW_PARSING_PANEL_MENU_GROUP_ID));
    }

    public void registerOptionsPanels() {
        OptionsModuleApi optionsModule = (OptionsModuleApi)this.application.getModuleRepository().getModuleByInterface(OptionsModuleApi.class);
        this.dataInspectorOptionsPage = new DefaultOptionsPage<DataInspectorOptionsImpl>(){
            private DataInspectorOptionsPanel panel;

            @Nonnull
            public OptionsComponent<DataInspectorOptionsImpl> createPanel() {
                if (this.panel == null) {
                    this.panel = new DataInspectorOptionsPanel();
                }
                return this.panel;
            }

            @Nonnull
            public ResourceBundle getResourceBundle() {
                return LanguageUtils.getResourceBundleByClass(DataInspectorOptionsPanel.class);
            }

            @Nonnull
            public DataInspectorOptionsImpl createOptions() {
                return new DataInspectorOptionsImpl();
            }

            public void loadFromPreferences(Preferences preferences, DataInspectorOptionsImpl options) {
                options.loadFromPreferences(new DataInspectorPreferences(preferences));
            }

            public void saveToPreferences(Preferences preferences, DataInspectorOptionsImpl options) {
                options.saveToPreferences(new DataInspectorPreferences(preferences));
            }

            public void applyPreferencesChanges(DataInspectorOptionsImpl options) {
                BinedInspectorModule.this.getShowParsingPanelAction().setShowValuesPanel(options.isShowParsingPanel());
            }
        };
        optionsModule.addOptionsPage(this.dataInspectorOptionsPage);
    }
}

