/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.command;

import java.util.Date;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.audio.swing.XBWavePanel;
import org.exbin.xbup.core.type.XBData;
import org.exbin.xbup.operation.AbstractCommand;

@ParametersAreNonnullByDefault
public class WaveReverseCommand
extends AbstractCommand {
    private XBWavePanel wave;
    private int startPosition;
    private int endPosition;
    private XBData deletedData;

    public WaveReverseCommand(XBWavePanel wave) {
        this(wave, -1, -1);
    }

    public WaveReverseCommand(XBWavePanel wave, int startPosition, int endPosition) {
        this.wave = wave;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    @Nonnull
    public String getCaption() {
        return "Wave section reversed";
    }

    public void execute() throws Exception {
        if (this.startPosition >= 0) {
            this.wave.getWave().performTransformReverse((long)this.startPosition, (long)this.endPosition);
        } else {
            this.wave.getWave().performTransformReverse();
        }
        this.wave.rebuildZoomCache();
    }

    public void redo() throws Exception {
        this.execute();
    }

    public void undo() throws Exception {
        this.execute();
    }

    public boolean canUndo() {
        return true;
    }

    public void dispose() throws Exception {
    }

    @Nonnull
    public Optional<Date> getExecutionTime() {
        return Optional.empty();
    }
}

