/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.command;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.framework.editor.wave.command.WaveClipboardData;
import org.exbin.xbup.audio.swing.XBWavePanel;
import org.exbin.xbup.audio.wave.XBWave;
import org.exbin.xbup.operation.AbstractCommand;

@ParametersAreNonnullByDefault
public class WavePasteCommand
extends AbstractCommand {
    private XBWave pastedWave;
    private final XBWavePanel wave;
    private final int startPosition;
    private int endPosition;
    private BinaryData deletedData;

    public WavePasteCommand(XBWavePanel wave, int startPosition) {
        this.wave = wave;
        this.startPosition = startPosition;
    }

    @Nonnull
    public String getCaption() {
        return "Wave section pasted";
    }

    public void execute() throws Exception {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(WaveClipboardData.WAVE_FLAVOR)) {
            this.pastedWave = (XBWave)clipboard.getData(WaveClipboardData.WAVE_FLAVOR);
        }
        this.endPosition = this.startPosition + this.wave.getWave().getLengthInTicks();
        this.wave.getWave().insertWave(this.pastedWave, this.startPosition);
        this.wave.rebuildZoomCache();
    }

    public void redo() throws Exception {
        this.wave.getWave().insertData(this.deletedData, this.startPosition);
        this.wave.rebuildZoomCache();
        this.deletedData = null;
    }

    public void undo() throws Exception {
        this.deletedData = this.wave.getWave().cutData(this.startPosition, this.endPosition - this.startPosition);
        this.wave.rebuildZoomCache();
    }

    public boolean canUndo() {
        return true;
    }

    public void dispose() throws Exception {
    }

    @Nonnull
    public Optional<Date> getExecutionTime() {
        return Optional.empty();
    }
}

