/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.wave.action;

import java.awt.event.ActionEvent;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.api.EditorProvider;
import org.exbin.framework.editor.wave.gui.AudioPanel;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class AudioControlActions {
    public static final String AUDIO_PLAY_ACTION_ID = "audioPlayAction";
    public static final String AUDIO_STOP_ACTION_ID = "audioStopAction";
    private EditorProvider editorProvider;
    private XBApplication application;
    private ResourceBundle resourceBundle;
    private Action audioPlayAction;
    private Action audioStopAction;

    public void setup(XBApplication application, EditorProvider editorProvider, ResourceBundle resourceBundle) {
        this.application = application;
        this.editorProvider = editorProvider;
        this.resourceBundle = resourceBundle;
    }

    @Nonnull
    public Action getPlayAction() {
        if (this.audioPlayAction == null) {
            this.audioPlayAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Optional activeFile = AudioControlActions.this.editorProvider.getActiveFile();
                    if (!activeFile.isPresent()) {
                        throw new IllegalStateException();
                    }
                    AudioPanel audioPanel = (AudioPanel)((FileHandler)activeFile.get()).getComponent();
                    audioPanel.performPlay();
                }
            };
            ActionUtils.setupAction((Action)this.audioPlayAction, (ResourceBundle)this.resourceBundle, (String)AUDIO_PLAY_ACTION_ID);
            this.audioPlayAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(32, 0));
        }
        return this.audioPlayAction;
    }

    @Nonnull
    public Action getStopAction() {
        if (this.audioStopAction == null) {
            this.audioStopAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Optional activeFile = AudioControlActions.this.editorProvider.getActiveFile();
                    if (!activeFile.isPresent()) {
                        throw new IllegalStateException();
                    }
                    AudioPanel audioPanel = (AudioPanel)((FileHandler)activeFile.get()).getComponent();
                    audioPanel.performStop();
                }
            };
            ActionUtils.setupAction((Action)this.audioStopAction, (ResourceBundle)this.resourceBundle, (String)AUDIO_STOP_ACTION_ID);
        }
        return this.audioStopAction;
    }
}

