/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.utils.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.exbin.framework.utils.UiUtils;

@ParametersAreNonnullByDefault
public class WindowHeaderPanel
extends JPanel {
    private BackgroundDecorationMode decorationMode = BackgroundDecorationMode.COLOR_BOTTOM_RIGHT_TRANSITION;
    private Color transitionColor = null;
    private Image decorationImage = null;
    private boolean darkMode = false;
    private final ImageObserver imageObserver = (img, infoflags, x, y, width, height) -> true;
    private JTextArea descriptionTextArea;
    private JLabel iconLabel;
    private JSeparator separator;
    private JPanel textPanel;
    private JLabel titleLabel;

    public WindowHeaderPanel() {
        this.initComponents();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.darkMode = UiUtils.isDarkUI();
        if (this.darkMode) {
            this.setBackground(Color.BLACK);
            this.titleLabel.setForeground(Color.WHITE);
            this.descriptionTextArea.setForeground(Color.WHITE);
            this.transitionColor = new Color(35, 35, 55);
        } else {
            this.transitionColor = new Color(220, 220, 230);
        }
    }

    private void initComponents() {
        this.separator = new JSeparator();
        this.textPanel = new JPanel();
        this.descriptionTextArea = new JTextArea();
        this.titleLabel = new JLabel();
        this.iconLabel = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new BorderLayout());
        this.add((Component)this.separator, "South");
        this.textPanel.setMinimumSize(new Dimension(16, 64));
        this.textPanel.setOpaque(false);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setColumns(20);
        this.descriptionTextArea.setForeground(Color.black);
        this.descriptionTextArea.setText("Line 1\nLine 2");
        this.descriptionTextArea.setBorder(null);
        this.descriptionTextArea.setOpaque(false);
        this.titleLabel.setForeground(Color.black);
        this.titleLabel.setText("Title");
        this.titleLabel.setVerticalAlignment(3);
        GroupLayout textPanelLayout = new GroupLayout(this.textPanel);
        this.textPanel.setLayout(textPanelLayout);
        textPanelLayout.setHorizontalGroup(textPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(textPanelLayout.createSequentialGroup().addContainerGap().addGroup(textPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionTextArea, -1, 192, Short.MAX_VALUE).addComponent(this.titleLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        textPanelLayout.setVerticalGroup(textPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(textPanelLayout.createSequentialGroup().addComponent(this.titleLabel, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionTextArea, -2, -1, -2).addGap(0, 0, 0)));
        this.add((Component)this.textPanel, "Center");
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setHorizontalTextPosition(0);
        this.iconLabel.setIconTextGap(0);
        this.iconLabel.setMinimumSize(new Dimension(64, 64));
        this.iconLabel.setPreferredSize(new Dimension(0, 64));
        this.add((Component)this.iconLabel, "East");
    }

    @Nonnull
    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    @Nonnull
    public String getDescription() {
        return this.descriptionTextArea.getText();
    }

    public void setDescription(String description) {
        this.descriptionTextArea.setText(description);
    }

    @Nullable
    public Icon getIcon() {
        return this.iconLabel.getIcon();
    }

    public void setIcon(Icon icon) {
        this.iconLabel.setIcon(icon);
        this.iconLabel.setPreferredSize(new Dimension(icon == null ? 0 : 64, 64));
    }

    @Nonnull
    public BackgroundDecorationMode getDecorationMode() {
        return this.decorationMode;
    }

    public void setDecorationMode(BackgroundDecorationMode decorationMode) {
        this.decorationMode = decorationMode;
        this.repaint();
    }

    @Nullable
    public Color getTransitionColor() {
        return this.transitionColor;
    }

    public void setTransitionColor(Color transitionColor) {
        this.transitionColor = transitionColor;
        this.repaint();
    }

    @Nullable
    public Image getDecorationImage() {
        return this.decorationImage;
    }

    public void setDecorationImage(Image decorationImage) {
        this.decorationImage = decorationImage;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        switch (this.decorationMode) {
            case COLOR_RIGHT_HORIZONTAL_TRANSITION: 
            case COLOR_TOP_RIGHT_TRANSITION: 
            case COLOR_BOTTOM_RIGHT_TRANSITION: {
                Dimension size = this.getSize();
                int topOffset = this.decorationMode == BackgroundDecorationMode.COLOR_BOTTOM_RIGHT_TRANSITION ? size.height : 0;
                int bottomOffset = this.decorationMode == BackgroundDecorationMode.COLOR_TOP_RIGHT_TRANSITION ? size.height : 0;
                Color backgroundColor = this.getBackground();
                int redChange = this.transitionColor.getRed() - backgroundColor.getRed();
                int greenChange = this.transitionColor.getGreen() - backgroundColor.getGreen();
                int blueChange = this.transitionColor.getBlue() - backgroundColor.getBlue();
                for (int i = 0; i < 96; ++i) {
                    Color color = new Color(this.transitionColor.getRed() - redChange * i / 95, this.transitionColor.getGreen() - greenChange * i / 95, this.transitionColor.getBlue() - blueChange * i / 95);
                    g.setColor(color);
                    g.drawLine(size.width - i + topOffset, 0, size.width - i + bottomOffset, size.height);
                }
                break;
            }
            case TOP_RIGHT_IMAGE: {
                if (this.decorationImage == null) break;
                Dimension size = this.getSize();
                int imageWidth = this.decorationImage.getWidth(this.imageObserver);
                g.drawImage(this.decorationImage, size.width - imageWidth, 0, this.imageObserver);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal decoration mode " + this.decorationMode.name());
            }
        }
    }

    @ParametersAreNonnullByDefault
    public static interface WindowHeaderDecorationProvider {
        public void setHeaderDecoration(WindowHeaderPanel var1);
    }

    public static enum BackgroundDecorationMode {
        PLAIN,
        COLOR_RIGHT_HORIZONTAL_TRANSITION,
        COLOR_TOP_RIGHT_TRANSITION,
        COLOR_BOTTOM_RIGHT_TRANSITION,
        TOP_RIGHT_IMAGE;

    }
}

