/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.operation.undo.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.exbin.framework.operation.undo.gui.UndoManagerModel;
import org.exbin.framework.operation.undo.service.UndoManagerService;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.xbup.operation.Command;
import org.exbin.xbup.operation.XBDocCommand;
import org.exbin.xbup.operation.XBTDocOperation;
import org.exbin.xbup.operation.XBTOpDocCommand;

@ParametersAreNonnullByDefault
public class UndoManagerPanel
extends JPanel {
    private final UndoManagerModel undoModel;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(UndoManagerPanel.class);
    private UndoManagerService undoManagerService;
    private JLabel commandCaptionLabel;
    private JTextField commandCaptionTextField;
    private JLabel commandTypeLabel;
    private JTextField commandTypeTextField;
    private JLabel dataSizeLabel;
    private JTextField dataSizeTextField;
    private JLabel executionTimeLabel;
    private JTextField executionTimeTextField;
    private JButton exportButton;
    private JLabel operationCaptionLabel;
    private JTextField operationCaptionTextField;
    private JLabel operationTypeLabel;
    private JTextField operationTypeTextField;
    private JSplitPane splitPane;
    private JPanel undoDetailInfoPanel;
    private JPanel undoDetailPanel;
    private JList undoList;
    private JScrollPane undoListScrollPane;

    public UndoManagerPanel(UndoManagerModel undoModel) {
        this.undoModel = undoModel;
        this.initComponents();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setUndoManagerService(UndoManagerService undoManagerService) {
        this.undoManagerService = undoManagerService;
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.undoListScrollPane = new JScrollPane();
        this.undoList = new JList();
        this.undoDetailPanel = new JPanel();
        this.undoDetailInfoPanel = new JPanel();
        this.commandCaptionLabel = new JLabel();
        this.commandCaptionTextField = new JTextField();
        this.commandTypeLabel = new JLabel();
        this.commandTypeTextField = new JTextField();
        this.executionTimeLabel = new JLabel();
        this.executionTimeTextField = new JTextField();
        this.operationCaptionLabel = new JLabel();
        this.operationCaptionTextField = new JTextField();
        this.operationTypeLabel = new JLabel();
        this.operationTypeTextField = new JTextField();
        this.dataSizeLabel = new JLabel();
        this.dataSizeTextField = new JTextField();
        this.exportButton = new JButton();
        this.setLayout(new BorderLayout());
        this.splitPane.setBorder(null);
        this.splitPane.setDividerLocation(200);
        this.undoList.setModel(this.undoModel);
        this.undoList.setSelectionMode(0);
        this.undoList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                UndoManagerPanel.this.undoListValueChanged(evt);
            }
        });
        this.undoListScrollPane.setViewportView(this.undoList);
        this.splitPane.setLeftComponent(this.undoListScrollPane);
        this.undoDetailInfoPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("undoDetailInfoPanel.border.title")));
        this.commandCaptionLabel.setText(this.resourceBundle.getString("commandCaptionLabel.text"));
        this.commandCaptionTextField.setEditable(false);
        this.commandTypeLabel.setText(this.resourceBundle.getString("commandTypeLabel.text"));
        this.commandTypeTextField.setEditable(false);
        this.executionTimeLabel.setText(this.resourceBundle.getString("executionTimeLabel.text"));
        this.executionTimeTextField.setEditable(false);
        this.operationCaptionLabel.setText(this.resourceBundle.getString("operationCaptionLabel.text"));
        this.operationCaptionTextField.setEditable(false);
        this.operationTypeLabel.setText(this.resourceBundle.getString("operationTypeLabel.text"));
        this.operationTypeTextField.setEditable(false);
        this.dataSizeLabel.setText(this.resourceBundle.getString("dataSizeLabel.text"));
        this.dataSizeTextField.setEditable(false);
        GroupLayout undoDetailInfoPanelLayout = new GroupLayout(this.undoDetailInfoPanel);
        this.undoDetailInfoPanel.setLayout(undoDetailInfoPanelLayout);
        undoDetailInfoPanelLayout.setHorizontalGroup(undoDetailInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(undoDetailInfoPanelLayout.createSequentialGroup().addContainerGap().addGroup(undoDetailInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commandCaptionTextField).addComponent(this.commandTypeTextField).addComponent(this.operationCaptionTextField).addComponent(this.operationTypeTextField).addGroup(undoDetailInfoPanelLayout.createSequentialGroup().addGroup(undoDetailInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commandCaptionLabel).addComponent(this.commandTypeLabel).addComponent(this.operationCaptionLabel).addComponent(this.operationTypeLabel)).addGap(0, 0, Short.MAX_VALUE)).addGroup(undoDetailInfoPanelLayout.createSequentialGroup().addGroup(undoDetailInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(undoDetailInfoPanelLayout.createSequentialGroup().addComponent(this.executionTimeLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.executionTimeTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(undoDetailInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.dataSizeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.dataSizeTextField)))).addContainerGap()));
        undoDetailInfoPanelLayout.setVerticalGroup(undoDetailInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(undoDetailInfoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.commandCaptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.commandCaptionTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.commandTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.commandTypeTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.operationCaptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.operationCaptionTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(undoDetailInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(undoDetailInfoPanelLayout.createSequentialGroup().addComponent(this.operationTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.operationTypeTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.executionTimeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.executionTimeTextField, -2, -1, -2)).addGroup(undoDetailInfoPanelLayout.createSequentialGroup().addComponent(this.dataSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataSizeTextField, -2, -1, -2))).addContainerGap(155, Short.MAX_VALUE)));
        this.exportButton.setText(this.resourceBundle.getString("exportButton.text"));
        this.exportButton.setEnabled(false);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UndoManagerPanel.this.exportButtonActionPerformed(evt);
            }
        });
        GroupLayout undoDetailPanelLayout = new GroupLayout(this.undoDetailPanel);
        this.undoDetailPanel.setLayout(undoDetailPanelLayout);
        undoDetailPanelLayout.setHorizontalGroup(undoDetailPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, undoDetailPanelLayout.createSequentialGroup().addGap(292, 422, Short.MAX_VALUE).addComponent(this.exportButton).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, undoDetailPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.undoDetailInfoPanel, -1, -1, Short.MAX_VALUE)));
        undoDetailPanelLayout.setVerticalGroup(undoDetailPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(undoDetailPanelLayout.createSequentialGroup().addComponent(this.undoDetailInfoPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportButton).addContainerGap()));
        this.splitPane.setRightComponent(this.undoDetailPanel);
        this.add((Component)this.splitPane, "First");
    }

    private void undoListValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.updateDetail(this.undoList.getSelectedIndex());
        }
    }

    private void exportButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.undoList.getSelectedIndex();
        Command command = null;
        if (selectedIndex >= 0) {
            command = this.undoModel.getItem(selectedIndex);
        }
        this.undoManagerService.exportCommand(this, command);
    }

    public long getCommandPosition() {
        return this.undoList.getSelectedIndex();
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new UndoManagerPanel(new UndoManagerModel()));
    }

    private void updateDetail(int selectedIndex) {
        Command command = null;
        if (selectedIndex >= 0) {
            command = this.undoModel.getItem(selectedIndex);
        }
        this.exportButton.setEnabled(command != null);
        this.commandCaptionTextField.setText(command != null ? command.getCaption() : "");
        this.commandTypeTextField.setText(command instanceof XBDocCommand ? ((XBDocCommand)command).getBasicType().name() : "");
        Date executionTime = command != null ? (Date)command.getExecutionTime().orElse(null) : null;
        this.executionTimeTextField.setText(executionTime != null ? executionTime.toString() : "");
        XBTDocOperation operation = null;
        if (command instanceof XBTOpDocCommand) {
            operation = ((XBTOpDocCommand)command).getCurrentOperation().orElse(null);
        }
        this.operationCaptionTextField.setText(operation != null ? operation.getCaption() : "");
        this.operationTypeTextField.setText(operation != null ? operation.getBasicType().name() : "");
        this.dataSizeTextField.setText(operation != null ? String.valueOf(operation.getData().getDataSize()) : "");
    }
}

