/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.search.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.KeyListener;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.ByteArrayEditableData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.bined.RowWrappingMode;
import org.exbin.bined.ScrollBarVisibility;
import org.exbin.bined.extended.layout.ExtendedCodeAreaLayoutProfile;
import org.exbin.bined.extended.theme.ExtendedBackgroundPaintMode;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.bined.swing.extended.theme.ExtendedCodeAreaThemeProfile;
import org.exbin.framework.bined.handler.CodeAreaPopupMenuHandler;
import org.exbin.framework.bined.search.SearchCondition;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class BinarySearchComboBoxPanel
extends JPanel {
    public static final String TEXT_MODE = "text";
    public static final String BINARY_MODE = "binary";
    private final JTextField textField;
    private final ExtCodeArea codeArea = new ExtCodeArea();
    private final SearchCondition item = new SearchCondition();
    private boolean runningUpdate = false;
    private ValueChangedListener valueChangedListener = null;

    public BinarySearchComboBoxPanel() {
        super.setLayout(new CardLayout());
        Border comboBoxBorder = ((JComponent)new JComboBox().getEditor().getEditorComponent()).getBorder();
        this.textField = new JTextField();
        this.textField.setBorder(comboBoxBorder);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BinarySearchComboBoxPanel.this.comboBoxValueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BinarySearchComboBoxPanel.this.comboBoxValueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BinarySearchComboBoxPanel.this.comboBoxValueChanged();
            }
        });
        super.add((Component)this.textField, TEXT_MODE);
        ExtendedCodeAreaLayoutProfile layoutProfile = this.codeArea.getLayoutProfile();
        layoutProfile.setShowHeader(false);
        layoutProfile.setShowRowPosition(false);
        this.codeArea.setLayoutProfile(layoutProfile);
        this.codeArea.setRowWrapping(RowWrappingMode.WRAPPING);
        this.codeArea.setWrappingBytesGroupSize(0);
        ExtendedCodeAreaThemeProfile themeProfile = this.codeArea.getThemeProfile();
        themeProfile.setBackgroundPaintMode(ExtendedBackgroundPaintMode.PLAIN);
        this.codeArea.setThemeProfile(themeProfile);
        this.codeArea.setVerticalScrollBarVisibility(ScrollBarVisibility.NEVER);
        this.codeArea.setHorizontalScrollBarVisibility(ScrollBarVisibility.NEVER);
        this.codeArea.setContentData((BinaryData)new ByteArrayEditableData());
        this.codeArea.setBorder(comboBoxBorder);
        this.codeArea.addDataChangedListener(this::comboBoxValueChanged);
        super.add((Component)this.codeArea, BINARY_MODE);
    }

    @Nonnull
    public SearchCondition getItem() {
        switch (this.item.getSearchMode()) {
            case TEXT: {
                this.item.setSearchText(this.textField.getText());
                break;
            }
            case BINARY: {
                this.item.setBinaryData((EditableBinaryData)this.codeArea.getContentData());
            }
        }
        return this.item;
    }

    public void setItem(SearchCondition item) {
        if (item == null) {
            item = new SearchCondition();
        }
        this.item.setSearchMode(item.getSearchMode());
        switch (item.getSearchMode()) {
            case TEXT: {
                this.item.setSearchText(item.getSearchText());
                this.item.setBinaryData(null);
                this.runningUpdate = true;
                this.textField.setText(item.getSearchText());
                this.runningUpdate = false;
                CardLayout layout = (CardLayout)this.getLayout();
                layout.show(this, TEXT_MODE);
                this.revalidate();
                break;
            }
            case BINARY: {
                this.item.setSearchText("");
                ByteArrayEditableData data = new ByteArrayEditableData();
                if (item.getBinaryData() != null) {
                    data.insert(0L, item.getBinaryData());
                }
                this.item.setBinaryData((EditableBinaryData)data);
                this.runningUpdate = true;
                this.codeArea.setContentData((BinaryData)data);
                this.runningUpdate = false;
                CardLayout layout = (CardLayout)this.getLayout();
                layout.show(this, BINARY_MODE);
                this.revalidate();
                break;
            }
        }
    }

    public void selectAll() {
        switch (this.item.getSearchMode()) {
            case TEXT: {
                this.textField.selectAll();
                break;
            }
            case BINARY: {
                this.codeArea.selectAll();
            }
        }
    }

    private void comboBoxValueChanged() {
        if (this.valueChangedListener != null && !this.runningUpdate) {
            this.valueChangedListener.valueChanged();
        }
    }

    public void addValueKeyListener(KeyListener editorKeyListener) {
        this.textField.addKeyListener(editorKeyListener);
        this.codeArea.addKeyListener(editorKeyListener);
    }

    public void setValueChangedListener(ValueChangedListener valueChangedListener) {
        this.valueChangedListener = valueChangedListener;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        switch (this.item.getSearchMode()) {
            case TEXT: {
                this.textField.requestFocus();
                break;
            }
            case BINARY: {
                this.codeArea.requestFocus();
            }
        }
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new BinarySearchComboBoxPanel());
    }

    public void setCodeAreaPopupMenuHandler(final CodeAreaPopupMenuHandler codeAreaPopupMenuHandler, final String postfix) {
        this.codeArea.setComponentPopupMenu(new JPopupMenu(){

            @Override
            public void show(Component invoker, int x, int y) {
                int clickedX = x;
                int clickedY = y;
                if (invoker instanceof JViewport) {
                    clickedX += ((JViewport)invoker).getParent().getX();
                    clickedY += ((JViewport)invoker).getParent().getY();
                }
                JPopupMenu popupMenu = codeAreaPopupMenuHandler.createPopupMenu(BinarySearchComboBoxPanel.this.codeArea, ".search" + postfix, clickedX, clickedY);
                popupMenu.show(invoker, x, y);
                codeAreaPopupMenuHandler.dropPopupMenu(".search" + postfix);
            }
        });
    }

    public void exclusiveUpdate(Runnable runnable) {
        this.runningUpdate = true;
        runnable.run();
        this.runningUpdate = false;
    }

    public void clear() {
        switch (this.item.getSearchMode()) {
            case TEXT: {
                String text = this.textField.getText();
                if ("".equals(text)) break;
                this.textField.setText("");
                break;
            }
            case BINARY: {
                EditableBinaryData contentData = (EditableBinaryData)this.codeArea.getContentData();
                if (contentData.isEmpty()) break;
                contentData.clear();
                break;
            }
        }
    }

    public static interface ValueChangedListener {
        public void valueChanged();
    }
}

