/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.search.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.bined.swing.extended.ExtCodeArea;
import org.exbin.framework.bined.handler.CodeAreaPopupMenuHandler;
import org.exbin.framework.bined.search.SearchCondition;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class BinaryMultilinePanel
extends JPanel {
    private static final String POPUP_MENU_POSTFIX = ".binaryMultilinePanel";
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(BinaryMultilinePanel.class);
    private SearchCondition condition;
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private ExtCodeArea codeArea;
    private CodeAreaPopupMenuHandler codeAreaPopupMenuHandler;

    public BinaryMultilinePanel() {
        this.initComponents();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new BorderLayout());
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new BinaryMultilinePanel());
    }

    @Nonnull
    public String getMultilineText() {
        return this.textArea.getText();
    }

    @Nonnull
    public SearchCondition getCondition() {
        if (this.condition.getSearchMode() == SearchCondition.SearchMode.TEXT) {
            this.condition.setSearchText(this.textArea.getText());
        } else {
            this.condition.setBinaryData((EditableBinaryData)this.codeArea.getContentData());
        }
        return this.condition;
    }

    public void setCondition(SearchCondition condition) {
        this.condition = condition;
        if (condition.getSearchMode() == SearchCondition.SearchMode.TEXT) {
            this.scrollPane = new JScrollPane();
            this.textArea = new JTextArea();
            this.textArea.setColumns(20);
            this.textArea.setRows(5);
            this.textArea.setName("textArea");
            this.scrollPane.setViewportView(this.textArea);
            this.textArea.setText(condition.getSearchText());
            this.add((Component)this.scrollPane, "Center");
        } else {
            this.codeArea = new ExtCodeArea();
            this.codeArea.setContentData(condition.getBinaryData());
            this.codeArea.setFocusTraversalKeysEnabled(false);
            this.add((Component)this.codeArea, "Center");
            if (this.codeAreaPopupMenuHandler != null) {
                this.attachPopupMenu();
            }
        }
        this.revalidate();
    }

    public void setCodeAreaPopupMenuHandler(CodeAreaPopupMenuHandler codeAreaPopupMenuHandler) {
        this.codeAreaPopupMenuHandler = codeAreaPopupMenuHandler;
        if (this.codeArea != null) {
            this.attachPopupMenu();
        }
    }

    private void attachPopupMenu() {
        this.codeArea.setComponentPopupMenu(new JPopupMenu(){

            @Override
            public void show(@Nonnull Component invoker, int x, int y) {
                int clickedX = x;
                int clickedY = y;
                if (invoker instanceof JViewport) {
                    clickedX += ((JViewport)invoker).getParent().getX();
                    clickedY += ((JViewport)invoker).getParent().getY();
                }
                JPopupMenu popupMenu = BinaryMultilinePanel.this.codeAreaPopupMenuHandler.createPopupMenu(BinaryMultilinePanel.this.codeArea, BinaryMultilinePanel.POPUP_MENU_POSTFIX, clickedX, clickedY);
                popupMenu.show(invoker, x, y);
                BinaryMultilinePanel.this.codeAreaPopupMenuHandler.dropPopupMenu(BinaryMultilinePanel.POPUP_MENU_POSTFIX);
            }
        });
    }

    public void detachMenu() {
        if (this.condition.getSearchMode() == SearchCondition.SearchMode.BINARY) {
            this.codeAreaPopupMenuHandler.dropPopupMenu(POPUP_MENU_POSTFIX);
        }
    }
}

