/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.bined.search;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.auxiliary.binary_data.ByteArrayEditableData;
import org.exbin.auxiliary.binary_data.EditableBinaryData;
import org.exbin.bined.CodeAreaUtils;

@ParametersAreNonnullByDefault
public class SearchCondition {
    private SearchMode searchMode = SearchMode.TEXT;
    private String searchText = "";
    private EditableBinaryData binaryData;

    public SearchCondition() {
    }

    public SearchCondition(SearchCondition source) {
        this.searchMode = source.getSearchMode();
        this.searchText = source.getSearchText();
        this.binaryData = new ByteArrayEditableData();
        if (source.getBinaryData() != null) {
            this.binaryData.insert(0L, source.getBinaryData());
        }
    }

    @Nonnull
    public SearchMode getSearchMode() {
        return this.searchMode;
    }

    public void setSearchMode(SearchMode searchMode) {
        this.searchMode = searchMode;
    }

    @Nonnull
    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    @Nullable
    public BinaryData getBinaryData() {
        return this.binaryData;
    }

    public void setBinaryData(EditableBinaryData binaryData) {
        this.binaryData = binaryData;
    }

    public boolean isEmpty() {
        switch (this.searchMode) {
            case TEXT: {
                return this.searchText == null || this.searchText.isEmpty();
            }
            case BINARY: {
                return this.binaryData == null || this.binaryData.isEmpty();
            }
        }
        throw CodeAreaUtils.getInvalidTypeException((Enum)this.searchMode);
    }

    public int hashCode() {
        int hash = 3;
        return hash;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchCondition other = (SearchCondition)obj;
        if (this.searchMode != other.searchMode) {
            return false;
        }
        if (this.searchMode == SearchMode.TEXT) {
            return Objects.equals(this.searchText, other.searchText);
        }
        return Objects.equals(this.binaryData, other.binaryData);
    }

    public void clear() {
        this.searchText = "";
        if (this.binaryData != null) {
            this.binaryData.clear();
        }
    }

    public static enum SearchMode {
        TEXT,
        BINARY;

    }
}

