/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.utils.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.OkCancelListener;
import org.exbin.framework.utils.UiUtils;
import org.exbin.framework.utils.handler.CloseControlHandler;

@ParametersAreNonnullByDefault
public class CloseControlPanel
extends JPanel
implements CloseControlHandler.CloseControlService {
    private final ResourceBundle resourceBundle;
    private CloseControlHandler handler;
    private OkCancelListener okCancelListener;
    private JButton closeButton;

    public CloseControlPanel() {
        this(LanguageUtils.getResourceBundleByClass(CloseControlPanel.class));
    }

    public CloseControlPanel(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.initComponents();
        this.okCancelListener = new OkCancelListener(){

            @Override
            public void okEvent() {
                CloseControlPanel.this.performCloseClick();
            }

            @Override
            public void cancelEvent() {
                CloseControlPanel.this.performCloseClick();
            }
        };
    }

    public void setHandler(CloseControlHandler handler) {
        this.handler = handler;
    }

    private void initComponents() {
        this.closeButton = new JButton();
        this.closeButton.setText(this.resourceBundle.getString("closeButton.text"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CloseControlPanel.this.closeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.closeButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.closeButton).addContainerGap()));
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        if (this.handler != null) {
            this.handler.controlActionPerformed();
        }
    }

    @Override
    public void performCloseClick() {
        UiUtils.doButtonClick(this.closeButton);
    }

    @Override
    @Nonnull
    public JButton getDefaultButton() {
        return this.closeButton;
    }

    @Override
    @Nonnull
    public OkCancelListener getOkCancelListener() {
        return this.okCancelListener;
    }

    @Override
    @Nonnull
    public CloseControlHandler.CloseControlEnablementListener createEnablementListener() {
        return this.closeButton::setEnabled;
    }
}

