/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.JTextComponent;
import org.exbin.framework.utils.OkCancelListener;
import org.exbin.framework.utils.UiUtils;
import org.exbin.framework.utils.WindowPosition;
import org.exbin.framework.utils.gui.WindowHeaderPanel;
import org.exbin.framework.utils.handler.OkCancelService;

@ParametersAreNonnullByDefault
public class WindowUtils {
    public static final String ESC_CANCEL_KEY = "esc-cancel";
    public static final String ENTER_OK_KEY = "enter-ok";
    private static LookAndFeel lookAndFeel = null;

    private WindowUtils() {
    }

    @Nonnull
    public static WindowHeaderPanel addHeaderPanel(@Nonnull Window window, @Nonnull Class<?> resourceClass, @Nonnull ResourceBundle resourceBundle) {
        URL iconUrl = resourceClass.getResource(resourceBundle.getString("header.icon"));
        ImageIcon headerIcon = iconUrl != null ? new ImageIcon(iconUrl) : null;
        return WindowUtils.addHeaderPanel(window, resourceBundle.getString("header.title"), resourceBundle.getString("header.description"), headerIcon);
    }

    @Nonnull
    public static WindowHeaderPanel addHeaderPanel(@Nonnull Window window, @Nonnull String headerTitle, @Nonnull String headerDescription, @Nullable Icon headerIcon) {
        WindowHeaderPanel headerPanel = new WindowHeaderPanel();
        headerPanel.setTitle(headerTitle);
        headerPanel.setDescription(headerDescription);
        if (headerIcon != null) {
            headerPanel.setIcon(headerIcon);
        }
        if (window instanceof WindowHeaderPanel.WindowHeaderDecorationProvider) {
            ((WindowHeaderPanel.WindowHeaderDecorationProvider)((Object)window)).setHeaderDecoration(headerPanel);
        } else {
            Frame frame = UiUtils.getFrame(window);
            if (frame instanceof WindowHeaderPanel.WindowHeaderDecorationProvider) {
                ((WindowHeaderPanel.WindowHeaderDecorationProvider)((Object)frame)).setHeaderDecoration(headerPanel);
            }
        }
        int height = window.getHeight() + headerPanel.getPreferredSize().height;
        ((JDialog)window).getContentPane().add((Component)headerPanel, "First");
        window.setSize(window.getWidth(), height);
        return headerPanel;
    }

    public static void invokeWindow(@Nonnull Window window) {
        if (lookAndFeel != null) {
            try {
                UIManager.setLookAndFeel(lookAndFeel);
            }
            catch (UnsupportedLookAndFeelException ex) {
                Logger.getLogger(WindowUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        EventQueue.invokeLater(() -> {
            if (window instanceof JDialog) {
                ((JDialog)window).setDefaultCloseOperation(2);
            }
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            window.setVisible(true);
        });
    }

    @Nonnull
    public static DialogWrapper createDialog(JComponent component, Component parent, String dialogTitle, Dialog.ModalityType modalityType) {
        final JDialog dialog = new JDialog(WindowUtils.getWindow(parent), modalityType);
        Dimension size = component.getPreferredSize();
        dialog.add(component);
        dialog.getContentPane().setPreferredSize(new Dimension(size.width, size.height));
        dialog.pack();
        dialog.setTitle(dialogTitle);
        if (component instanceof OkCancelService) {
            WindowUtils.assignGlobalKeyListener((Component)dialog, ((OkCancelService)((Object)component)).getOkCancelListener());
        }
        return new DialogWrapper(){

            @Override
            public void show() {
                dialog.setVisible(true);
            }

            @Override
            public void showCentered(@Nullable Component component) {
                this.center(component);
                this.show();
            }

            @Override
            public void close() {
                WindowUtils.closeWindow(dialog);
            }

            @Override
            public void dispose() {
                dialog.dispose();
            }

            @Override
            public Window getWindow() {
                return dialog;
            }

            @Override
            public Container getParent() {
                return dialog.getParent();
            }

            @Override
            public void center(@Nullable Component component) {
                if (component == null) {
                    this.center();
                } else {
                    dialog.setLocationRelativeTo(component);
                }
            }

            @Override
            public void center() {
                dialog.setLocationByPlatform(true);
            }
        };
    }

    @Nonnull
    public static JDialog createDialog(JComponent component) {
        JDialog dialog = new JDialog();
        Dimension size = component.getPreferredSize();
        dialog.add(component);
        dialog.getContentPane().setPreferredSize(new Dimension(size.width, size.height));
        dialog.pack();
        if (component instanceof OkCancelService) {
            WindowUtils.assignGlobalKeyListener((Component)dialog, ((OkCancelService)((Object)component)).getOkCancelListener());
        }
        return dialog;
    }

    public static void invokeDialog(JComponent component) {
        JDialog dialog = WindowUtils.createDialog(component);
        WindowUtils.invokeWindow(dialog);
    }

    @Nullable
    public static LookAndFeel getLookAndFeel() {
        return lookAndFeel;
    }

    public static void setLookAndFeel(LookAndFeel lookAndFeel) {
        WindowUtils.lookAndFeel = lookAndFeel;
    }

    public static void closeWindow(Window window) {
        window.dispatchEvent(new WindowEvent(window, 201));
    }

    @Nonnull
    public static JDialog createBasicDialog() {
        JDialog dialog = new JDialog((Frame)new JFrame(), true);
        dialog.setSize(640, 480);
        dialog.setLocationByPlatform(true);
        return dialog;
    }

    @Nullable
    public static Window getWindow(Component component) {
        return SwingUtilities.getWindowAncestor(component);
    }

    public static void assignGlobalKeyListener(Component component, JButton closeButton) {
        WindowUtils.assignGlobalKeyListener(component, closeButton, closeButton);
    }

    public static void assignGlobalKeyListener(Component component, final JButton okButton, final JButton cancelButton) {
        WindowUtils.assignGlobalKeyListener(component, new OkCancelListener(){

            @Override
            public void okEvent() {
                UiUtils.doButtonClick(okButton);
            }

            @Override
            public void cancelEvent() {
                UiUtils.doButtonClick(cancelButton);
            }
        });
    }

    public static void assignGlobalKeyListener(Component component, final @Nullable OkCancelListener listener) {
        final JRootPane rootPane = SwingUtilities.getRootPane(component);
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), ESC_CANCEL_KEY);
        rootPane.getActionMap().put(ESC_CANCEL_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (listener == null) {
                    return;
                }
                boolean performCancelAction = true;
                Window window = SwingUtilities.getWindowAncestor(event.getSource() instanceof JRootPane ? (JRootPane)event.getSource() : rootPane);
                if (window != null) {
                    Component focusOwner = window.getFocusOwner();
                    if (focusOwner instanceof JComboBox) {
                        performCancelAction = !((JComboBox)focusOwner).isPopupVisible();
                    } else if (focusOwner instanceof JRootPane) {
                        // empty if block
                    }
                }
                if (performCancelAction) {
                    listener.cancelEvent();
                }
            }
        });
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), ENTER_OK_KEY);
        rootPane.getActionMap().put(ENTER_OK_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Component focusOwner;
                if (listener == null) {
                    return;
                }
                boolean performOkAction = true;
                Window window = SwingUtilities.getWindowAncestor(event.getSource() instanceof JRootPane ? (JRootPane)event.getSource() : rootPane);
                if (window != null && ((focusOwner = window.getFocusOwner()) instanceof JTextArea || focusOwner instanceof JEditorPane)) {
                    boolean bl = performOkAction = !((JTextComponent)focusOwner).isEditable();
                }
                if (performOkAction) {
                    listener.okEvent();
                }
            }
        });
    }

    @Nonnull
    public static WindowPosition getWindowPosition(Window window) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screenDevices = ge.getScreenDevices();
        int windowX = window.getX();
        int windowY = window.getY();
        int screenX = 0;
        int screenY = 0;
        int screenWidth = 0;
        int screenHeight = 0;
        int screenIndex = 0;
        for (GraphicsDevice screen : screenDevices) {
            Rectangle bounds = screen.getDefaultConfiguration().getBounds();
            if (bounds.contains(windowX, windowY)) {
                screenX = bounds.x;
                screenY = bounds.y;
                screenWidth = bounds.width;
                screenHeight = bounds.height;
                break;
            }
            ++screenIndex;
        }
        WindowPosition position = new WindowPosition();
        position.setScreenIndex(screenIndex);
        position.setScreenWidth(screenWidth);
        position.setScreenHeight(screenHeight);
        position.setRelativeX(window.getX() - screenX);
        position.setRelativeY(window.getY() - screenY);
        position.setWidth(window.getWidth());
        position.setHeight(window.getHeight());
        position.setMaximized(window instanceof Frame ? (((Frame)window).getExtendedState() & 6) > 0 : false);
        return position;
    }

    public static void setWindowPosition(Window window, WindowPosition position) {
        double widthY;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screenDevices = ge.getScreenDevices();
        GraphicsDevice device = screenDevices.length > position.getScreenIndex() ? screenDevices[position.getScreenIndex()] : ge.getDefaultScreenDevice();
        Rectangle screenBounds = device.getDefaultConfiguration().getBounds();
        double absoluteX = position.getScreenWidth() > 0 ? (double)(screenBounds.x + position.getRelativeX() * screenBounds.width / position.getScreenWidth()) : (double)(screenBounds.x + position.getRelativeX());
        double absoluteY = position.getScreenHeight() > 0 ? (double)(screenBounds.y + position.getRelativeY() * screenBounds.height / position.getScreenHeight()) : (double)(screenBounds.y + position.getRelativeY());
        double widthX = position.getScreenWidth() > 0 ? (double)(position.getWidth() * screenBounds.width / position.getScreenWidth()) : (double)position.getWidth();
        double d = widthY = position.getScreenHeight() > 0 ? (double)(position.getHeight() * screenBounds.height / position.getScreenHeight()) : (double)position.getHeight();
        if (position.isMaximized()) {
            window.setLocation((int)absoluteX, (int)absoluteY);
            if (window instanceof Frame) {
                ((Frame)window).setExtendedState(6);
            } else if (window instanceof Window) {
                // empty if block
            }
        } else {
            window.setBounds((int)absoluteX, (int)absoluteY, (int)widthX, (int)widthY);
        }
    }

    @Nonnull
    public static JPanel createDialogPanel(JComponent mainComponent, JPanel controlPanel) {
        JPanel dialogPanel = controlPanel instanceof OkCancelService ? new DialogPanel((OkCancelService)((Object)controlPanel)) : new JPanel(new BorderLayout());
        dialogPanel.add((Component)mainComponent, "Center");
        dialogPanel.add((Component)controlPanel, "South");
        Dimension mainPreferredSize = mainComponent.getPreferredSize();
        Dimension controlPreferredSize = controlPanel.getPreferredSize();
        int height = mainPreferredSize.height + (controlPreferredSize != null ? controlPreferredSize.height : 0);
        dialogPanel.setPreferredSize(new Dimension(mainPreferredSize.width, height));
        return dialogPanel;
    }

    @ParametersAreNonnullByDefault
    public static interface DialogWrapper {
        public void show();

        public void showCentered(@Nullable Component var1);

        public void close();

        public void dispose();

        @Nonnull
        public Window getWindow();

        @Nonnull
        public Container getParent();

        public void center(@Nullable Component var1);

        public void center();
    }

    @ParametersAreNonnullByDefault
    private static final class DialogPanel
    extends JPanel
    implements OkCancelService {
        private final OkCancelService okCancelService;

        public DialogPanel(OkCancelService okCancelService) {
            super(new BorderLayout());
            this.okCancelService = okCancelService;
        }

        @Override
        @Nullable
        public JButton getDefaultButton() {
            return null;
        }

        @Override
        @Nonnull
        public OkCancelListener getOkCancelListener() {
            return this.okCancelService.getOkCancelListener();
        }
    }
}

