/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.picture;

import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.filechooser.FileFilter;
import org.exbin.framework.file.api.FileType;

@ParametersAreNonnullByDefault
public class PictureFileType
extends FileFilter
implements FileType {
    private String ext;

    public PictureFileType(String ext) {
        this.ext = ext;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = PictureFileType.getExtension(f);
        if (extension != null) {
            return extension.toLowerCase().equals(this.getExt());
        }
        return false;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Images " + this.getExt().toUpperCase() + " (*." + this.getExt() + ")";
    }

    @Nullable
    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    @Nonnull
    public String getExt() {
        return this.ext;
    }

    public void setExt(String ext) {
        this.ext = ext;
    }

    @Nonnull
    public String getFileTypeId() {
        return "XBPictureEditor.PictureFileType" + this.ext;
    }
}

