/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.service.skeleton;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.exbin.xbup.catalog.XBAECatalog;
import org.exbin.xbup.catalog.entity.service.XBEXNameService;
import org.exbin.xbup.client.stub.XBPXNameStub;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.XBTEmptyBlock;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCXLanguage;
import org.exbin.xbup.core.catalog.base.XBCXName;
import org.exbin.xbup.core.catalog.base.service.XBCItemService;
import org.exbin.xbup.core.catalog.base.service.XBCXLangService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.remote.XBExecutable;
import org.exbin.xbup.core.remote.XBMultiProcedure;
import org.exbin.xbup.core.remote.XBServiceServer;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.stream.XBInput;
import org.exbin.xbup.core.stream.XBOutput;
import org.exbin.xbup.core.type.XBString;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.service.skeleton.XBPCatalogSkeleton;

public class XBPXNameSkeleton
implements XBPCatalogSkeleton {
    private XBAECatalog catalog;

    public XBPXNameSkeleton(XBAECatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public void registerProcedures(XBServiceServer remoteServer) {
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXNameStub.ITEM_NAME_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCXNameService nameService = (XBCXNameService)XBPXNameSkeleton.this.catalog.getCatalogService(XBCXNameService.class);
                Optional name = nameService.getItem(index.getNaturalLong());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(name.isPresent() ? new UBNat32(((XBCXName)name.get()).getId()) : XBTEmptyBlock.getEmptyBlock()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXNameStub.TEXT_NAME_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCXNameService nameService = (XBCXNameService)XBPXNameSkeleton.this.catalog.getCatalogService(XBCXNameService.class);
                Optional name = nameService.getItem(index.getNaturalLong());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(name.isPresent() ? new XBString(((XBCXName)name.get()).getText()) : XBTEmptyBlock.getEmptyBlock()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXNameStub.LANG_NAME_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCXNameService nameService = (XBCXNameService)XBPXNameSkeleton.this.catalog.getCatalogService(XBCXNameService.class);
                Optional name = nameService.getItem(index.getNaturalLong());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(name.isPresent() ? new UBNat32(((XBCXName)name.get()).getLang().getId()) : XBTEmptyBlock.getEmptyBlock()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXNameStub.ITEMNAME_NAME_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCItemService itemService = (XBCItemService)XBPXNameSkeleton.this.catalog.getCatalogService(XBCItemService.class);
                XBCXNameService nameService = (XBCXNameService)XBPXNameSkeleton.this.catalog.getCatalogService(XBCXNameService.class);
                Optional item = itemService.getItem(index.getNaturalLong());
                XBCXName name = nameService.getDefaultItemName((XBCItem)item.get());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(name == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(name.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXNameStub.LANGNAME_NAME_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                XBAttribute langIndex = provider.pullAttribute();
                provider.end();
                XBCItemService itemService = (XBCItemService)XBPXNameSkeleton.this.catalog.getCatalogService(XBCItemService.class);
                XBCXLangService langService = (XBCXLangService)XBPXNameSkeleton.this.catalog.getCatalogService(XBCXLangService.class);
                XBCXNameService nameService = (XBCXNameService)XBPXNameSkeleton.this.catalog.getCatalogService(XBCXNameService.class);
                Optional item = itemService.getItem(index.getNaturalLong());
                Optional lang = langService.getItem(langIndex.getNaturalLong());
                XBCXName name = nameService.getItemName((XBCItem)item.get(), (XBCXLanguage)lang.get());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)(name == null ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(name.getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXNameStub.ITEMNAMES_NAME_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBCItemService itemService = (XBCItemService)XBPXNameSkeleton.this.catalog.getCatalogService(XBCItemService.class);
                XBCXNameService nameService = (XBCXNameService)XBPXNameSkeleton.this.catalog.getCatalogService(XBCXNameService.class);
                Optional item = itemService.getItem(index.getNaturalLong());
                List itemNames = nameService.getItemNames((XBCItem)item.get());
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.begin();
                listener.putType((XBBlockType)new XBFixedBlockType());
                listener.putAttribute(itemNames.size());
                for (XBCXName itemName : itemNames) {
                    listener.putAttribute(itemName.getId());
                }
                listener.end();
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPXNameStub.NAMESCOUNT_NAME_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                provider.end();
                XBEXNameService nameService = (XBEXNameService)XBPXNameSkeleton.this.catalog.getCatalogService(XBCXNameService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(nameService.getItemsCount()));
            }
        });
    }

    @Override
    public void setCatalog(XBAECatalog catalog) {
        this.catalog = catalog;
    }
}

