/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.service.skeleton;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Optional;
import org.exbin.xbup.catalog.XBAECatalog;
import org.exbin.xbup.catalog.convert.XBCatalogXb;
import org.exbin.xbup.client.stub.XBPRootStub;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBTEmptyBlock;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.base.XBCRoot;
import org.exbin.xbup.core.catalog.base.service.XBCRootService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.remote.XBExecutable;
import org.exbin.xbup.core.remote.XBMultiProcedure;
import org.exbin.xbup.core.remote.XBServiceServer;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.stream.XBInput;
import org.exbin.xbup.core.stream.XBOutput;
import org.exbin.xbup.core.type.XBDateTime;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.service.skeleton.XBPCatalogSkeleton;

public class XBPRootSkeleton
implements XBPCatalogSkeleton {
    private XBAECatalog catalog;

    public XBPRootSkeleton(XBAECatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public void registerProcedures(XBServiceServer remoteServer) {
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPRootStub.CATALOG_ROOT_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                provider.end();
                XBCRootService rootService = (XBCRootService)XBPRootSkeleton.this.catalog.getCatalogService(XBCRootService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                XBCRoot root = rootService.getMainRoot();
                listener.process((XBSerializable)new UBNat32(root.getId()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPRootStub.LASTUPDATE_ROOT_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long rootId = provider.pullLongAttribute();
                provider.end();
                XBCRootService rootService = (XBCRootService)XBPRootSkeleton.this.catalog.getCatalogService(XBCRootService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                Optional root = rootService.getItem(rootId);
                Date lastUpdate = root.isPresent() ? (Date)((XBCRoot)root.get()).getLastUpdate().orElse(null) : null;
                listener.process((XBSerializable)(lastUpdate == null ? XBTEmptyBlock.getEmptyBlock() : new XBDateTime(lastUpdate)));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPRootStub.ROOT_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                long rootId = provider.pullLongAttribute();
                provider.end();
                XBCRootService rootService = (XBCRootService)XBPRootSkeleton.this.catalog.getCatalogService(XBCRootService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                Optional root = rootService.getItem(rootId);
                listener.process((XBSerializable)(root.isPresent() ? new UBNat32(((XBCRoot)root.get()).getId()) : XBTEmptyBlock.getEmptyBlock()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPRootStub.CATALOG_MAIN_EXPORT_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                provider.end();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                XBCatalogXb catalogXb = new XBCatalogXb();
                catalogXb.setCatalog((XBACatalog)XBPRootSkeleton.this.catalog);
                catalogXb.exportToXbStream((OutputStream)outputStream);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.begin();
                listener.putData((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
                listener.end();
            }
        });
    }

    @Override
    public void setCatalog(XBAECatalog catalog) {
        this.catalog = catalog;
    }
}

