/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.service.skeleton;

import java.io.IOException;
import java.util.Optional;
import org.exbin.xbup.catalog.XBAECatalog;
import org.exbin.xbup.catalog.entity.service.XBEItemService;
import org.exbin.xbup.client.stub.XBPItemStub;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.XBTEmptyBlock;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.service.XBCItemService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.remote.XBExecutable;
import org.exbin.xbup.core.remote.XBMultiProcedure;
import org.exbin.xbup.core.remote.XBServiceServer;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.stream.XBInput;
import org.exbin.xbup.core.stream.XBOutput;
import org.exbin.xbup.core.ubnumber.type.UBNat32;
import org.exbin.xbup.service.skeleton.XBPCatalogSkeleton;

public class XBPItemSkeleton
implements XBPCatalogSkeleton {
    private XBAECatalog catalog;

    public XBPItemSkeleton(XBAECatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public void registerProcedures(XBServiceServer remoteServer) {
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPItemStub.OWNER_ITEM_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBEItemService itemService = (XBEItemService)XBPItemSkeleton.this.catalog.getCatalogService(XBCItemService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                Optional item = itemService.getItem(index.getNaturalLong());
                listener.process((XBSerializable)(!item.isPresent() || !((XBCItem)item.get()).getParentItem().isPresent() ? XBTEmptyBlock.getEmptyBlock() : new UBNat32(((XBCItem)((XBCItem)item.get()).getParentItem().get()).getId())));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPItemStub.XBINDEX_ITEM_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                XBAttribute index = provider.pullAttribute();
                provider.end();
                XBEItemService itemService = (XBEItemService)XBPItemSkeleton.this.catalog.getCatalogService(XBCItemService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                Optional item = itemService.getItem(index.getNaturalLong());
                listener.process((XBSerializable)(item.isPresent() ? new UBNat32(((XBCItem)item.get()).getXBIndex()) : XBTEmptyBlock.getEmptyBlock()));
            }
        });
        remoteServer.addXBProcedure((XBBlockType)new XBDeclBlockType(XBPItemStub.ITEMSCOUNT_ITEM_PROCEDURE), (XBExecutable)new XBMultiProcedure(){

            public void execute(XBBlockType blockType, XBOutput parameters, XBInput resultInput) throws XBProcessingException, IOException {
                XBPProviderSerialHandler provider = new XBPProviderSerialHandler(parameters);
                provider.begin();
                provider.matchType(blockType);
                provider.end();
                XBEItemService itemService = (XBEItemService)XBPItemSkeleton.this.catalog.getCatalogService(XBCItemService.class);
                XBPListenerSerialHandler listener = new XBPListenerSerialHandler(resultInput);
                listener.process((XBSerializable)new UBNat32(itemService.getItemsCount()));
            }
        });
    }

    @Override
    public void setCatalog(XBAECatalog catalog) {
        this.catalog = catalog;
    }
}

