/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.client.XBLoggingInputStream;
import org.exbin.xbup.client.XBLoggingOutputStream;
import org.exbin.xbup.client.XBTCPServiceClient;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.declaration.XBBlockDecl;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.block.declaration.catalog.XBCBlockDecl;
import org.exbin.xbup.core.block.declaration.local.XBLBlockDecl;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.parser.XBParserMode;
import org.exbin.xbup.core.parser.XBParsingException;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.basic.XBHead;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTEndToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.parser.token.event.XBEventWriter;
import org.exbin.xbup.core.parser.token.event.XBTEventListener;
import org.exbin.xbup.core.parser.token.event.convert.XBTEventTypeUndeclaringFilterNoDeclaration;
import org.exbin.xbup.core.parser.token.event.convert.XBTPrintEventFilter;
import org.exbin.xbup.core.parser.token.event.convert.XBTToXBEventConvertor;
import org.exbin.xbup.core.parser.token.pull.XBPullProvider;
import org.exbin.xbup.core.parser.token.pull.XBPullReader;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.parser.token.pull.convert.XBTPrintPullFilter;
import org.exbin.xbup.core.parser.token.pull.convert.XBTPullTypeDeclaringFilterNoDeclaration;
import org.exbin.xbup.core.parser.token.pull.convert.XBToXBTPullConvertor;
import org.exbin.xbup.core.remote.XBExecutable;
import org.exbin.xbup.core.remote.XBMultiProcedure;
import org.exbin.xbup.core.remote.XBProcedure;
import org.exbin.xbup.core.remote.XBServiceServer;
import org.exbin.xbup.core.stream.XBInput;
import org.exbin.xbup.core.stream.XBOutput;
import org.exbin.xbup.service.entity.ServiceELogItem;
import org.exbin.xbup.service.entity.service.ServiceELogItemService;

@ParametersAreNonnullByDefault
public class XBTCPServiceServer
implements XBServiceServer {
    private static final int BACK_LOG_LIMIT = 50;
    private ServerSocket serverSocket;
    protected XBACatalog catalog = null;
    private CatalogProvider catalogProvider;
    private boolean stop = false;
    private final Map<XBBlockType, XBExecutable> procMap = new HashMap<XBBlockType, XBExecutable>();
    private boolean debugMode = false;

    public void open(int port) throws IOException {
        this.serverSocket = new ServerSocket(port);
    }

    public void open(int port, InetAddress bindAddr) throws IOException {
        this.serverSocket = new ServerSocket(port, 50, bindAddr);
    }

    public void run() throws XBProcessingException {
        try {
            Socket socket = this.getServerSocket().accept();
            Logger.getLogger(XBTCPServiceServer.class.getName()).log(XBHead.XB_DEBUG_LEVEL, "Request from: " + socket.getInetAddress().getHostAddress());
            OutputStream outputStream = null;
            try {
                ServiceELogItemService logItemService = new ServiceELogItemService();
                Object inputStream = this.debugMode ? new XBLoggingInputStream(socket.getInputStream()) : socket.getInputStream();
                outputStream = this.debugMode ? new XBLoggingOutputStream(socket.getOutputStream()) : socket.getOutputStream();
                XBHead.checkXBUPHead((InputStream)inputStream);
                while (!this.isStop()) {
                    if (this.catalog == null) {
                        this.replaceCatalog();
                    }
                    this.respondMessage((InputStream)inputStream, outputStream);
                    if (!this.debugMode) continue;
                    ServiceELogItem logItem = (ServiceELogItem)logItemService.createItem();
                    logItem.setCreated(new Date());
                    ByteArrayOutputStream requestOutputStream = new ByteArrayOutputStream();
                    inputStream.getData().saveToStream((OutputStream)requestOutputStream);
                    logItem.setRequestData(requestOutputStream.toByteArray());
                    ByteArrayOutputStream responseOutputStream = new ByteArrayOutputStream();
                    ((XBLoggingOutputStream)outputStream).getData().saveToStream((OutputStream)responseOutputStream);
                    logItem.setResponseData(responseOutputStream.toByteArray());
                    logItemService.persistItem(logItem);
                }
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(XBTCPServiceServer.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(XBTCPServiceServer.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException | XBParsingException ex) {
            Logger.getLogger(XBTCPServiceServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void stop() {
        this.setStop(true);
        try {
            this.getServerSocket().close();
        }
        catch (IOException ex) {
            Logger.getLogger(XBTCPServiceServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void respondMessage(InputStream inputStream, OutputStream outputStream) throws IOException, XBProcessingException {
        XBTTypePreloadingPullProvider preloading;
        XBTPullTypeDeclaringFilterNoDeclaration input = new XBTPullTypeDeclaringFilterNoDeclaration((XBCatalog)this.catalog, (XBTPullProvider)new XBTPrintPullFilter("I", (XBTPullProvider)new XBToXBTPullConvertor((XBPullProvider)new XBPullReader(inputStream, XBParserMode.SINGLE_BLOCK))));
        try {
            preloading = new XBTTypePreloadingPullProvider((XBTPullProvider)input);
        }
        catch (Exception ex) {
            this.replaceCatalog();
            input.setCatalog((XBCatalog)this.catalog);
            preloading = new XBTTypePreloadingPullProvider((XBTPullProvider)input);
        }
        XBTEventTypeUndeclaringFilterNoDeclaration output = new XBTEventTypeUndeclaringFilterNoDeclaration((XBCatalog)this.catalog, (XBTEventListener)new XBTPrintEventFilter("O", (XBTEventListener)new XBTToXBEventConvertor((XBEventListener)new XBEventWriter(outputStream, XBParserMode.SINGLE_BLOCK))));
        XBDeclBlockType blockType = (XBDeclBlockType)preloading.getBlockType();
        XBCBlockDecl blockDecl = (XBCBlockDecl)blockType.getBlockDecl();
        XBCSpecService specService = (XBCSpecService)this.catalog.getCatalogService(XBCSpecService.class);
        blockType.setBlockDecl((XBBlockDecl)new XBLBlockDecl(specService.getSpecXBPath((XBCSpec)blockDecl.getBlockSpecRev().getParent()), (int)blockDecl.getBlockSpecRev().getXBIndex()));
        XBExecutable executable = this.procMap.get(blockType);
        ExecutionEventListener eventListener = new ExecutionEventListener(output);
        if (executable instanceof XBProcedure) {
            ((XBProcedure)executable).execute((XBOutput)preloading, (XBInput)eventListener);
        } else if (executable instanceof XBMultiProcedure) {
            ((XBMultiProcedure)executable).execute((XBBlockType)blockType, (XBOutput)preloading, (XBInput)eventListener);
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        eventListener.putXBTToken((XBTToken)XBTEndToken.create());
    }

    public void addXBProcedure(XBBlockType procedureType, XBExecutable procedure) {
        this.procMap.put(procedureType, procedure);
    }

    public void removeXBProcedure(XBBlockType procedureType) {
        this.procMap.remove(procedureType);
    }

    @Nullable
    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public boolean isStop() {
        return this.stop;
    }

    @Nonnull
    public Map<XBBlockType, XBExecutable> getProcMap() {
        return this.procMap;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void setCatalogProvider(CatalogProvider catalogProvider) {
        this.catalogProvider = catalogProvider;
    }

    public void replaceCatalog() {
        this.catalog = this.catalogProvider.createCatalog();
    }

    @ParametersAreNonnullByDefault
    private class ExecutionEventListener
    implements XBTEventListener {
        private boolean started = false;
        private final XBTEventTypeUndeclaringFilterNoDeclaration output;

        public ExecutionEventListener(XBTEventTypeUndeclaringFilterNoDeclaration output) {
            this.output = output;
        }

        public void putXBTToken(XBTToken token) throws XBProcessingException, IOException {
            if (!this.started) {
                this.output.putXBTToken((XBTToken)XBTBeginToken.create((XBBlockTerminationMode)XBBlockTerminationMode.SIZE_SPECIFIED));
                this.output.putXBTToken((XBTToken)XBTTypeToken.create((XBBlockType)new XBDeclBlockType(XBTCPServiceClient.SERVICE_INVOCATION_SUCCESSFUL)));
                this.started = true;
            }
            this.output.putXBTToken(token);
        }
    }

    @ParametersAreNonnullByDefault
    private class XBTTypePreloadingPullProvider
    implements XBTPullProvider {
        private final XBTPullProvider pullProvider;
        private XBTBeginToken beginToken;
        private XBTTypeToken typeToken;

        public XBTTypePreloadingPullProvider(XBTPullProvider pullProvider) throws XBProcessingException, IOException {
            this.pullProvider = pullProvider;
            this.beginToken = (XBTBeginToken)pullProvider.pullXBTToken();
            this.typeToken = (XBTTypeToken)pullProvider.pullXBTToken();
        }

        @Nonnull
        public XBTToken pullXBTToken() throws XBProcessingException, IOException {
            if (this.typeToken == null) {
                return this.pullProvider.pullXBTToken();
            }
            if (this.beginToken != null) {
                XBTBeginToken token = this.beginToken;
                this.beginToken = null;
                return token;
            }
            XBTTypeToken token = this.typeToken;
            this.typeToken = null;
            return token;
        }

        @Nonnull
        public XBBlockType getBlockType() {
            return this.typeToken.getBlockType();
        }
    }

    public static interface CatalogProvider {
        @Nonnull
        public XBACatalog createCatalog();
    }
}

