/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util;

import bibliothek.util.workarounds.Java6Workaround;
import bibliothek.util.workarounds.Java7Workaround;
import bibliothek.util.workarounds.Workaround;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

public class Workarounds {
    private static Workarounds workarounds = new Workarounds();
    private List<Workaround> code = new ArrayList<Workaround>();

    public static Workarounds getDefault() {
        return workarounds;
    }

    public static void setDefault(Workarounds workarounds) {
        if (workarounds == null) {
            throw new IllegalArgumentException("workarounds must not be null");
        }
        Workarounds.workarounds = workarounds;
    }

    public void addWorkaround(Workaround workaround) {
        this.code.add(workaround);
    }

    public void removeWorkaround(Workaround workaround) {
        this.code.remove(workaround);
    }

    public Workaround[] getWorkarounds() {
        return this.code.toArray(new Workaround[this.code.size()]);
    }

    public void markAsGlassPane(Component component) {
        for (Workaround listener : this.code.toArray(new Workaround[this.code.size()])) {
            listener.markAsGlassPane(component);
        }
    }

    public boolean makeTransparent(Window window) {
        boolean result = false;
        for (Workaround listener : this.code.toArray(new Workaround[this.code.size()])) {
            result = listener.makeTransparent(window) || result;
        }
        return result;
    }

    static {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.6")) {
            Workarounds.getDefault().addWorkaround(new Java6Workaround());
        } else {
            Workarounds.getDefault().addWorkaround(new Java7Workaround());
        }
    }
}

