/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.station.stack.DefaultStackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentParent;
import bibliothek.gui.dock.themes.color.TabColor;
import java.awt.Color;

public class BasicStackDockComponent
extends DefaultStackDockComponent {
    private StackDockComponentParent station;

    public BasicStackDockComponent(StackDockComponentParent station) {
        this.station = station;
    }

    protected DefaultStackDockComponent.Tab createTab(Dockable dockable) {
        return new BasicTab(dockable);
    }

    public boolean hasBorder() {
        return false;
    }

    protected class BasicTab
    extends DefaultStackDockComponent.Tab
    implements DockableFocusListener {
        private TabColor colorForeground;
        private TabColor colorForegroundSelected;
        private TabColor colorForegroundFocused;
        private TabColor colorBackground;
        private TabColor colorBackgroundSelected;
        private TabColor colorBackgroundFocused;
        private TabColor[] colors;
        private DockController controller;

        public BasicTab(Dockable dockable) {
            super(dockable);
            this.colorForeground = new BasicTabColor("stack.tab.foreground");
            this.colorForegroundSelected = new BasicTabColor("stack.tab.foreground.selected");
            this.colorForegroundFocused = new BasicTabColor("stack.tab.foreground.focused");
            this.colorBackground = new BasicTabColor("stack.tab.background");
            this.colorBackgroundSelected = new BasicTabColor("stack.tab.background.selected");
            this.colorBackgroundFocused = new BasicTabColor("stack.tab.background.focused");
            this.colors = new TabColor[]{this.colorForeground, this.colorForegroundSelected, this.colorForegroundFocused, this.colorBackground, this.colorBackgroundSelected, this.colorBackgroundFocused};
        }

        public void setController(DockController controller) {
            if (this.controller != null) {
                this.controller.removeDockableFocusListener(this);
            }
            super.setController(controller);
            this.controller = controller;
            for (TabColor color : this.colors) {
                color.connect(controller);
            }
            if (controller != null) {
                controller.addDockableFocusListener(this);
            }
            this.updateColors();
        }

        private void updateColors() {
            int index = BasicStackDockComponent.this.station.indexOf(this.getDockable());
            if (index >= 0 && index < BasicStackDockComponent.this.getTabCount()) {
                boolean focused = this.controller == null ? false : this.controller.getFocusedDockable() == this.getDockable();
                boolean selected = index == BasicStackDockComponent.this.getSelectedIndex();
                Color foreground = null;
                Color background = null;
                if (focused) {
                    foreground = (Color)this.colorForegroundFocused.value();
                    background = (Color)this.colorBackgroundFocused.value();
                } else if (selected) {
                    foreground = (Color)this.colorForegroundSelected.value();
                    background = (Color)this.colorBackgroundSelected.value();
                } else {
                    foreground = (Color)this.colorForeground.value();
                    background = (Color)this.colorBackground.value();
                }
                BasicStackDockComponent.this.setForegroundAt(index, foreground);
                BasicStackDockComponent.this.setBackgroundAt(index, background);
            }
        }

        public void dockableFocused(DockableFocusEvent event) {
            this.updateColors();
        }

        private class BasicTabColor
        extends TabColor {
            public BasicTabColor(String id) {
                super(id, BasicStackDockComponent.this.station.getStackDockParent(), BasicTab.this.dockable, null);
            }

            protected void changed(Color oldColor, Color newColor) {
                BasicTab.this.updateColors();
            }
        }
    }
}

