/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.flat;

import bibliothek.extension.gui.dock.theme.FlatTheme;
import bibliothek.extension.gui.dock.theme.flat.FlatDockableDisplayer;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.displayer.DisplayerRequest;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayer;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayerDecorator;
import bibliothek.gui.dock.title.DockTitle;

public class FlatDisplayerFactory
implements DisplayerFactory {
    private boolean border;

    public FlatDisplayerFactory(boolean border) {
        this.border = border;
    }

    public void request(DisplayerRequest request) {
        Dockable dockable = request.getTarget();
        DockStation station = request.getParent();
        DockTitle title = request.getTitle();
        DockableDisplayer.Location location = dockable.asDockStation() != null ? DockableDisplayer.Location.LEFT : DockableDisplayer.Location.TOP;
        if (this.border) {
            FlatDockableDisplayer displayer = new FlatDockableDisplayer(station, dockable, title, location);
            displayer.setStacked(station instanceof StackDockStation);
            request.answer(displayer);
            return;
        }
        BasicDockableDisplayer displayer = new BasicDockableDisplayer(station, dockable, title, location){

            protected BasicDockableDisplayerDecorator createStackedDecorator() {
                return this.createStackedDecorator(FlatTheme.ACTION_DISTRIBUTOR);
            }
        };
        displayer.setRespectBorderHint(false);
        displayer.setDefaultBorderHint(false);
        displayer.setSingleTabShowInnerBorder(false);
        displayer.setSingleTabShowOuterBorder(false);
        displayer.setStacked(station instanceof StackDockStation);
        request.answer(displayer);
    }
}

