/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.action.gui;

import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import org.exbin.framework.action.gui.DropDownButtonPanel;

@ParametersAreNonnullByDefault
public class DropDownButton
extends JButton {
    private final DropDownButtonPanel buttonPanel;
    private final JPopupMenu popupMenu;

    public DropDownButton(Action action, JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
        this.buttonPanel = new DropDownButtonPanel();
        this.init(action);
    }

    private void init(Action action) {
        this.setFocusable(false);
        this.setActionText((String)action.getValue("Name"));
        this.addActionListener(action);
        action.addPropertyChangeListener(evt -> this.setEnabled(action.isEnabled()));
        String toolTipText = (String)action.getValue("ShortDescription");
        this.setToolTipText(toolTipText);
        this.setActionTooltip(toolTipText);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.add(this.buttonPanel);
        final JLabel actionButton = this.buttonPanel.getActionButton();
        final JButton menuButton = this.buttonPanel.getMenuButton();
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
            }

            @Override
            public void mousePressed(MouseEvent me) {
                if (me.getSource() == actionButton) {
                    menuButton.setSelected(true);
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (me.getSource() == actionButton) {
                    menuButton.setSelected(false);
                }
            }

            @Override
            public void mouseEntered(MouseEvent me) {
                DropDownButton.this.setRolloverBorder();
            }

            @Override
            public void mouseExited(MouseEvent me) {
                DropDownButton.this.unsetRolloverBorder();
            }
        };
        actionButton.addMouseListener(ma);
        menuButton.addMouseListener(ma);
        menuButton.addActionListener(ae -> this.popupMenu.show(actionButton, 0, actionButton.getSize().height));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.buttonPanel != null) {
            this.buttonPanel.updateUI();
        }
        if (this.popupMenu != null) {
            this.popupMenu.updateUI();
        }
    }

    protected void setRolloverBorder() {
        JButton menuButton = this.buttonPanel.getMenuButton();
        menuButton.setBorderPainted(true);
    }

    protected void unsetRolloverBorder() {
        JButton menuButton = this.buttonPanel.getMenuButton();
        menuButton.setBorderPainted(false);
    }

    public void setActionText(String value) {
        this.buttonPanel.getActionButton().setText(" " + value + " ");
    }

    public void setActionTooltip(String text) {
        this.buttonPanel.getActionButton().setToolTipText(text);
        this.buttonPanel.getMenuButton().setToolTipText(text);
    }
}

