/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.action;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.exbin.framework.action.ToolBarDefinition;
import org.exbin.framework.action.api.ActionToolBarContribution;
import org.exbin.framework.action.api.PositionMode;
import org.exbin.framework.action.api.SeparationMode;
import org.exbin.framework.action.api.ToolBarContribution;
import org.exbin.framework.action.api.ToolBarGroup;
import org.exbin.framework.action.api.ToolBarPosition;
import org.exbin.framework.action.gui.DropDownButton;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class ToolBarHandler {
    private Map<String, ToolBarDefinition> toolBars = new HashMap<String, ToolBarDefinition>();
    private Map<String, List<ToolBarGroup>> toolBarGroups = new HashMap<String, List<ToolBarGroup>>();
    private Set<String> toolBarModified = new HashSet<String>();
    private Map<String, String> pluginsUsage = new HashMap<String, String>();

    public void buildToolBar(JToolBar targetToolBar, String toolBarId) {
        ToolBarGroupRecord toolBarGroupRecord;
        ToolBarDefinition toolBarDef = this.toolBars.get(toolBarId);
        if (toolBarDef == null) {
            return;
        }
        LinkedList<ToolBarGroupRecord> groupRecords = new LinkedList<ToolBarGroupRecord>();
        HashMap<String, ToolBarGroupRecord> groupsMap = new HashMap<String, ToolBarGroupRecord>();
        for (PositionMode mode : PositionMode.values()) {
            toolBarGroupRecord = new ToolBarGroupRecord(mode.name());
            groupsMap.put(mode.name(), toolBarGroupRecord);
            groupRecords.add(toolBarGroupRecord);
        }
        List<ToolBarGroup> groups = this.toolBarGroups.get(toolBarId);
        if (groups != null) {
            for (ToolBarGroup group : groups) {
                ToolBarGroupRecord toolBarGroupRecord2;
                ToolBarGroupRecord groupRecord;
                String groupId = group.getGroupId();
                SeparationMode separationMode = group.getSeparationMode();
                ToolBarPosition position = group.getPosition();
                if (position.getBasicMode() != null) {
                    groupRecord = (ToolBarGroupRecord)groupsMap.get(position.getBasicMode().name());
                    toolBarGroupRecord2 = new ToolBarGroupRecord(groupId);
                    toolBarGroupRecord2.separationMode = separationMode;
                    groupRecord.subGroups.add(toolBarGroupRecord2);
                    groupsMap.put(groupId, toolBarGroupRecord2);
                    continue;
                }
                groupRecord = (ToolBarGroupRecord)groupsMap.get(position.getGroupId());
                toolBarGroupRecord2 = new ToolBarGroupRecord(groupId);
                toolBarGroupRecord2.separationMode = separationMode;
                groupRecord.subGroups.add(toolBarGroupRecord2);
                groupsMap.put(groupId, toolBarGroupRecord2);
            }
        }
        for (ToolBarContribution contribution : toolBarDef.getContributions()) {
            ToolBarPosition toolBarPosition = contribution.getToolBarPosition();
            if (toolBarPosition.getBasicMode() != null) {
                toolBarGroupRecord = (ToolBarGroupRecord)groupsMap.get(toolBarPosition.getBasicMode().name());
                toolBarGroupRecord.contributions.add(contribution);
                continue;
            }
            toolBarGroupRecord = (ToolBarGroupRecord)groupsMap.get(toolBarPosition.getGroupId());
            toolBarGroupRecord.contributions.add(contribution);
        }
        this.processToolBarGroup(groupRecords, targetToolBar);
    }

    private void processToolBarGroup(List<ToolBarGroupRecord> groups, JToolBar targetToolBar) {
        LinkedList<ToolBarGroupRecordPathNode> processingPath = new LinkedList<ToolBarGroupRecordPathNode>();
        processingPath.add(new ToolBarGroupRecordPathNode(groups));
        boolean separatorQueued = false;
        boolean toolBarContinues = false;
        while (!processingPath.isEmpty()) {
            ToolBarGroupRecordPathNode pathNode = (ToolBarGroupRecordPathNode)processingPath.get(processingPath.size() - 1);
            if (pathNode.childIndex == pathNode.records.size()) {
                processingPath.remove(processingPath.size() - 1);
                continue;
            }
            ToolBarGroupRecord groupRecord = pathNode.records.get(pathNode.childIndex);
            ++pathNode.childIndex;
            if ((groupRecord.separationMode == SeparationMode.ABOVE || groupRecord.separationMode == SeparationMode.AROUND) && toolBarContinues) {
                targetToolBar.addSeparator();
                separatorQueued = false;
            }
            for (ToolBarContribution contribution : groupRecord.contributions) {
                if (separatorQueued) {
                    targetToolBar.addSeparator();
                    separatorQueued = false;
                }
                if (contribution instanceof ActionToolBarContribution) {
                    JComponent toolBarItem;
                    Action action = ((ActionToolBarContribution)contribution).getAction();
                    ActionUtils.ActionType actionType = (ActionUtils.ActionType)action.getValue("type");
                    if (actionType != null) {
                        switch (actionType) {
                            case CHECK: {
                                JToggleButton newItem;
                                if (action.getValue("SmallIcon") != null) {
                                    newItem = new JToggleButton(action);
                                    newItem.setFocusable(false);
                                    newItem.setHorizontalTextPosition(0);
                                    newItem.setVerticalTextPosition(3);
                                    toolBarItem = newItem;
                                    break;
                                }
                                newItem = new JCheckBox(action);
                                newItem.setFocusable(false);
                                newItem.setHorizontalTextPosition(0);
                                newItem.setVerticalTextPosition(3);
                                toolBarItem = newItem;
                                break;
                            }
                            case RADIO: {
                                JToggleButton newItem = new JRadioButton(action);
                                newItem.setFocusable(false);
                                newItem.setHorizontalTextPosition(0);
                                newItem.setVerticalTextPosition(3);
                                toolBarItem = newItem;
                                break;
                            }
                            case CYCLE: {
                                JPopupMenu popupMenu = (JPopupMenu)action.getValue("cyclePopupMenu");
                                DropDownButton dropDown = new DropDownButton(action, popupMenu);
                                dropDown.setActionTooltip((String)action.getValue("ShortDescription"));
                                action.addPropertyChangeListener(evt -> dropDown.setActionText((String)action.getValue("Name")));
                                toolBarItem = dropDown;
                                break;
                            }
                            default: {
                                toolBarItem = this.createDefaultToolBarItem(action);
                                break;
                            }
                        }
                    } else {
                        toolBarItem = this.createDefaultToolBarItem(action);
                    }
                    targetToolBar.add(toolBarItem);
                }
                toolBarContinues = true;
            }
            if (groupRecord.separationMode == SeparationMode.AROUND || groupRecord.separationMode == SeparationMode.BELOW) {
                separatorQueued = true;
            }
            if (groupRecord.subGroups.isEmpty()) continue;
            processingPath.add(new ToolBarGroupRecordPathNode(groupRecord.subGroups));
        }
    }

    @Nonnull
    private JComponent createDefaultToolBarItem(Action action) {
        JButton newItem = new JButton(action);
        newItem.setFocusable(false);
        newItem.setHorizontalTextPosition(0);
        newItem.setVerticalTextPosition(3);
        return newItem;
    }

    public void registerToolBar(String toolBarId, String pluginId) {
        if (toolBarId == null) {
            throw new NullPointerException("Tool Bar Id cannot be null");
        }
        if (pluginId == null) {
            throw new NullPointerException("Plugin Id cannot be null");
        }
        ToolBarDefinition toolBar = this.toolBars.get(toolBarId);
        if (toolBar != null) {
            throw new IllegalStateException("Tool bar with ID " + toolBarId + " already exists.");
        }
        ToolBarDefinition toolBarDefinition = new ToolBarDefinition(pluginId);
        this.toolBars.put(toolBarId, toolBarDefinition);
    }

    public void registerToolBarGroup(String toolBarId, ToolBarGroup toolBarGroup) {
        List<ToolBarGroup> groups = this.toolBarGroups.get(toolBarId);
        if (groups == null) {
            groups = new LinkedList<ToolBarGroup>();
            this.toolBarGroups.put(toolBarId, groups);
        }
        groups.add(toolBarGroup);
    }

    public void registerToolBarItem(String toolBarId, String pluginId, Action action, ToolBarPosition position) {
        ToolBarDefinition toolBarDef = this.toolBars.get(toolBarId);
        if (toolBarDef == null) {
            throw new IllegalStateException("Tool bar with Id " + toolBarId + " doesn't exist");
        }
        ActionToolBarContribution toolBarContribution = new ActionToolBarContribution(action, position);
        toolBarDef.getContributions().add((ToolBarContribution)toolBarContribution);
    }

    @ParametersAreNonnullByDefault
    private class ToolBarGroupRecordPathNode {
        List<ToolBarGroupRecord> records;
        int childIndex;

        public ToolBarGroupRecordPathNode(List<ToolBarGroupRecord> records) {
            this.records = records;
        }
    }

    @ParametersAreNonnullByDefault
    private class ToolBarGroupRecord {
        String groupId;
        SeparationMode separationMode;
        List<ToolBarGroupRecord> subGroups = new LinkedList<ToolBarGroupRecord>();
        List<ToolBarContribution> contributions = new LinkedList<ToolBarContribution>();

        public ToolBarGroupRecord(String groupId) {
            this.groupId = groupId;
        }

        public ToolBarGroupRecord(String groupId, SeparationMode separationMode) {
            this(groupId);
            this.separationMode = separationMode;
        }
    }
}

