/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.action;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.ClipboardActionsHandler;
import org.exbin.framework.utils.ClipboardActionsUpdater;
import org.exbin.framework.utils.ClipboardUtils;

@ParametersAreNonnullByDefault
public class ClipboardActions
implements ClipboardActionsUpdater {
    public static final String EDIT_SELECT_ALL_ACTION_ID = "popupSelectAllAction";
    public static final String EDIT_DELETE_ACTION_ID = "popupDeleteAction";
    public static final String EDIT_PASTE_ACTION_ID = "popupPasteAction";
    public static final String EDIT_COPY_ACTION_ID = "popupCopyAction";
    public static final String EDIT_CUT_ACTION_ID = "popupCutAction";
    private ResourceBundle resourceBundle;
    private ClipboardActionsHandler clipboardActionsHandler = null;
    private FlavorListener clipboardFlavorListener;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action deleteAction;
    private Action selectAllAction;

    public void setup(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    @Nonnull
    public Action getCutAction() {
        if (this.cutAction == null) {
            this.cutAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ClipboardActions.this.clipboardActionsHandler != null) {
                        ClipboardActions.this.clipboardActionsHandler.performCut();
                    }
                }
            };
            ActionUtils.setupAction((Action)this.cutAction, (ResourceBundle)this.resourceBundle, (String)EDIT_CUT_ACTION_ID);
            this.cutAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, ActionUtils.getMetaMask()));
            this.cutAction.setEnabled(false);
        }
        return this.cutAction;
    }

    @Nonnull
    public Action getCopyAction() {
        if (this.copyAction == null) {
            this.copyAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ClipboardActions.this.clipboardActionsHandler != null) {
                        ClipboardActions.this.clipboardActionsHandler.performCopy();
                    }
                }
            };
            ActionUtils.setupAction((Action)this.copyAction, (ResourceBundle)this.resourceBundle, (String)EDIT_COPY_ACTION_ID);
            this.copyAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, ActionUtils.getMetaMask()));
            this.copyAction.setEnabled(false);
        }
        return this.copyAction;
    }

    @Nonnull
    public Action getPasteAction() {
        if (this.pasteAction == null) {
            this.pasteAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ClipboardActions.this.clipboardActionsHandler != null) {
                        ClipboardActions.this.clipboardActionsHandler.performPaste();
                    }
                }
            };
            ActionUtils.setupAction((Action)this.pasteAction, (ResourceBundle)this.resourceBundle, (String)EDIT_PASTE_ACTION_ID);
            this.pasteAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, ActionUtils.getMetaMask()));
            this.pasteAction.setEnabled(false);
        }
        return this.pasteAction;
    }

    @Nonnull
    public Action getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ClipboardActions.this.clipboardActionsHandler != null) {
                        ClipboardActions.this.clipboardActionsHandler.performDelete();
                    }
                }
            };
            ActionUtils.setupAction((Action)this.deleteAction, (ResourceBundle)this.resourceBundle, (String)EDIT_DELETE_ACTION_ID);
            this.deleteAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
            this.deleteAction.setEnabled(false);
        }
        return this.deleteAction;
    }

    @Nonnull
    public Action getSelectAllAction() {
        if (this.selectAllAction == null) {
            this.selectAllAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ClipboardActions.this.clipboardActionsHandler != null) {
                        ClipboardActions.this.clipboardActionsHandler.performSelectAll();
                    }
                }
            };
            ActionUtils.setupAction((Action)this.selectAllAction, (ResourceBundle)this.resourceBundle, (String)EDIT_SELECT_ALL_ACTION_ID);
            this.selectAllAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, ActionUtils.getMetaMask()));
        }
        return this.selectAllAction;
    }

    public void setClipboardActionsHandler(ClipboardActionsHandler clipboardActionsHandler) {
        this.clipboardActionsHandler = clipboardActionsHandler;
        this.updateClipboardActions();
    }

    public void updateClipboardActions() {
        if (this.cutAction != null) {
            this.cutAction.setEnabled(this.clipboardActionsHandler != null && this.clipboardActionsHandler.isEditable() && this.clipboardActionsHandler.isSelection());
        }
        if (this.copyAction != null) {
            this.copyAction.setEnabled(this.clipboardActionsHandler != null && this.clipboardActionsHandler.isSelection());
        }
        if (this.pasteAction != null) {
            this.pasteAction.setEnabled(this.clipboardActionsHandler != null && this.clipboardActionsHandler.isEditable() && this.clipboardActionsHandler.canPaste());
        }
        if (this.deleteAction != null) {
            this.deleteAction.setEnabled(this.clipboardActionsHandler != null && this.clipboardActionsHandler.canDelete() && this.clipboardActionsHandler.isSelection());
        }
        if (this.selectAllAction != null) {
            this.selectAllAction.setEnabled(this.clipboardActionsHandler != null && this.clipboardActionsHandler.canSelectAll());
        }
    }

    public void registerClipboardListener() {
        Clipboard clipboard = ClipboardUtils.getClipboard();
        this.clipboardFlavorListener = e -> this.updateClipboardActions();
        clipboard.addFlavorListener(this.clipboardFlavorListener);
    }

    public void unregisterClipboardListener() {
        Clipboard clipboard = ClipboardUtils.getClipboard();
        clipboard.removeFlavorListener(this.clipboardFlavorListener);
        this.clipboardFlavorListener = null;
    }
}

