/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import org.exbin.framework.file.api.FileHandler;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class MultiEditorPanel
extends JPanel {
    private final List<FileHandler> fileHandlers = new ArrayList<FileHandler>();
    private Controller controller;
    private int activeIndex = -1;
    private JTabbedPane tabbedPane;

    public MultiEditorPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tabbedPane.addChangeListener(e -> {
            int selectedIndex = this.tabbedPane.getSelectedIndex();
            this.changeActiveIndex(selectedIndex);
        });
        this.tabbedPane.setComponentPopupMenu(new JPopupMenu(){

            @Override
            public void show(Component invoker, int x, int y) {
                int index = MultiEditorPanel.this.tabbedPane.indexAtLocation(x, y);
                if (MultiEditorPanel.this.controller != null) {
                    MultiEditorPanel.this.controller.showPopupMenu(index, invoker, x, y);
                }
            }
        });
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public int getFileHandlersCount() {
        return this.fileHandlers.size();
    }

    @Nonnull
    public FileHandler getFileHandler(int index) {
        return this.fileHandlers.get(index);
    }

    public void addFileHandler(FileHandler fileHandler, String text) {
        this.fileHandlers.add(fileHandler);
        this.tabbedPane.addTab(text, fileHandler.getComponent());
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
    }

    public void insertFileHandler(int position, FileHandler fileHandler, String text) {
        this.fileHandlers.add(position, fileHandler);
        this.tabbedPane.insertTab(text, null, fileHandler.getComponent(), null, position);
        this.tabbedPane.setSelectedIndex(position);
    }

    public void removeFileHandler(FileHandler fileHandler) {
        int index = this.fileHandlers.indexOf(fileHandler);
        if (index >= 0) {
            this.removeFileHandlerAt(index);
        }
    }

    public void removeFileHandlerAt(int index) {
        if (index == this.activeIndex) {
            this.changeActiveIndex(-1);
        } else if (index < this.activeIndex) {
            this.changeActiveIndex(this.activeIndex--);
        }
        this.fileHandlers.remove(index);
        this.tabbedPane.removeTabAt(index);
    }

    public void removeAllFileHandlers() {
        for (int i = this.fileHandlers.size() - 1; i >= 0; --i) {
            this.removeFileHandlerAt(i);
        }
    }

    public void removeAllFileHandlersExceptFile(FileHandler exceptHandler) {
        for (int i = this.fileHandlers.size() - 1; i >= 0; --i) {
            if (this.fileHandlers.get(i) == exceptHandler) continue;
            this.removeFileHandlerAt(i);
        }
    }

    private void changeActiveIndex(int index) {
        if (this.activeIndex != index) {
            this.activeIndex = index;
            this.notifyActiveIndexChanged();
        }
    }

    private void notifyActiveIndexChanged() {
        if (this.controller != null) {
            this.controller.activeIndexChanged(this.activeIndex);
        }
    }

    public void updateFileHandlerAt(int index, String text) {
        Component component = this.tabbedPane.getTabComponentAt(index);
        component.setName(text);
    }

    public int getActiveIndex() {
        return this.activeIndex;
    }

    @Nonnull
    public Optional<FileHandler> getActiveFile() {
        if (this.activeIndex == -1 || this.fileHandlers.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.fileHandlers.get(this.getActiveIndex()));
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new MultiEditorPanel());
    }

    @ParametersAreNonnullByDefault
    public static interface Controller {
        public void activeIndexChanged(int var1);

        public void showPopupMenu(int var1, Component var2, int var3, int var4);
    }
}

