/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.serial;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.token.event.XBEventListener;
import org.exbin.xbup.core.parser.token.event.convert.XBEventListenerToListener;
import org.exbin.xbup.core.serial.XBSerialReader;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.XBWriteSerialHandler;
import org.exbin.xbup.core.serial.basic.XBBasicSerializable;
import org.exbin.xbup.core.serial.basic.XBListenerSerialHandler;
import org.exbin.xbup.core.serial.child.XBChildListenerSerialHandler;
import org.exbin.xbup.core.serial.child.XBChildSerializable;
import org.exbin.xbup.core.serial.token.XBEventListenerSerialHandler;
import org.exbin.xbup.core.serial.token.XBTokenSerializable;

@ParametersAreNonnullByDefault
public class XBSerialWriter
implements XBWriteSerialHandler {
    private final XBEventListener eventListener;

    public XBSerialWriter(XBEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    public void write(XBSerializable serial) {
        if (serial instanceof XBBasicSerializable) {
            XBListenerSerialHandler listenerHandler = new XBListenerSerialHandler();
            listenerHandler.attachXBListener(new XBEventListenerToListener(this.eventListener));
            try {
                ((XBBasicSerializable)serial).serializeToXB(listenerHandler);
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(XBSerialReader.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (serial instanceof XBTokenSerializable) {
            XBEventListenerSerialHandler listenerHandler = new XBEventListenerSerialHandler();
            listenerHandler.attachXBEventListener(this.eventListener);
            try {
                ((XBTokenSerializable)serial).serializeToXB(listenerHandler);
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(XBSerialReader.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (serial instanceof XBChildSerializable) {
            XBChildListenerSerialHandler childOutput = new XBChildListenerSerialHandler(this);
            childOutput.attachXBEventListener(this.eventListener);
            try {
                ((XBChildSerializable)serial).serializeToXB(childOutput);
            }
            catch (IOException | XBProcessingException ex) {
                Logger.getLogger(XBSerialReader.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            throw new UnsupportedOperationException("Serialization method " + serial.getClass().getCanonicalName() + " not supported.");
        }
    }

    public static boolean isValidSerializableObject(XBSerializable serial) {
        return serial instanceof XBBasicSerializable || serial instanceof XBTokenSerializable || serial instanceof XBChildSerializable;
    }
}

