/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token.pull.convert;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.definition.XBBlockParam;
import org.exbin.xbup.core.catalog.XBACatalog;
import org.exbin.xbup.core.parser.XBParserState;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTEndToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTokenType;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.pull.XBTPullFilter;
import org.exbin.xbup.core.parser.token.pull.XBTPullProvider;
import org.exbin.xbup.core.parser.token.pull.convert.XBTPullPreLoader;

@ParametersAreNonnullByDefault
public class XBTPullParamFilter
implements XBTPullFilter {
    private XBTPullPreLoader pullProvider;
    private int currentParameter = 0;
    private int targetParameter = 0;
    private XBBlockParam currentParamType;
    private XBParserState state = XBParserState.START;
    private XBBlockType blockType;
    private final List<XBTAttributeToken> attributeList = new ArrayList<XBTAttributeToken>();

    public XBTPullParamFilter(XBACatalog catalog) {
    }

    @Override
    public void attachXBTPullProvider(XBTPullProvider provider) {
        this.pullProvider = provider instanceof XBTPullPreLoader ? (XBTPullPreLoader)provider : new XBTPullPreLoader(provider);
    }

    public void init() throws XBProcessingException, IOException {
        if (this.pullProvider.pullXBTToken().getTokenType() != XBTTokenType.BEGIN) {
            throw new XBProcessingException("Begin token was expected for parameters processing", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        XBTToken typeToken = this.pullProvider.pullXBTToken();
        if (typeToken.getTokenType() != XBTTokenType.TYPE) {
            throw new XBProcessingException("Type token was expected for parameters processing", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        this.blockType = ((XBTTypeToken)typeToken).getBlockType();
        this.attributeList.clear();
        while (this.pullProvider.getNextTokenType() == XBTTokenType.ATTRIBUTE) {
            this.attributeList.add((XBTAttributeToken)this.pullProvider.pullXBTToken());
        }
    }

    @Override
    @Nonnull
    public XBTToken pullXBTToken() throws XBProcessingException, IOException {
        if (this.state == XBParserState.START) {
            return XBTEndToken.create();
        }
        if (this.currentParameter == this.targetParameter) {
            return this.pullProvider.pullXBTToken();
        }
        return XBTEndToken.create();
    }

    public void setParameterIndex(int parameterIndex) throws XBProcessingException {
        if (parameterIndex < this.currentParameter) {
            throw new XBProcessingException("Cannot process already processed parameter", XBProcessingExceptionType.UNEXPECTED_ORDER);
        }
        this.targetParameter = parameterIndex;
    }
}

