/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTokenType;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

@ParametersAreNonnullByDefault
public abstract class XBTAttributeToken
implements XBTToken {
    @Nullable
    private static XBTZeroAttributeToken instance = null;

    @Nonnull
    public abstract XBAttribute getAttribute();

    public abstract boolean isZero();

    @Override
    @Nonnull
    public XBTTokenType getTokenType() {
        return XBTTokenType.ATTRIBUTE;
    }

    @Nonnull
    public static XBTAttributeToken create(XBAttribute attribute) {
        return new XBTAttributeTokenImpl(attribute);
    }

    @Nonnull
    public static XBTAttributeToken createZeroToken() {
        if (instance == null) {
            instance = new XBTZeroAttributeToken();
        }
        return instance;
    }

    @ParametersAreNonnullByDefault
    private static class XBTZeroAttributeToken
    extends XBTAttributeToken {
        private XBTZeroAttributeToken() {
        }

        @Override
        @Nonnull
        public XBAttribute getAttribute() {
            return new UBNat32();
        }

        @Override
        public boolean isZero() {
            return true;
        }
    }

    @ParametersAreNonnullByDefault
    private static class XBTAttributeTokenImpl
    extends XBTAttributeToken {
        @Nonnull
        private final XBAttribute attribute;

        private XBTAttributeTokenImpl(XBAttribute attribute) {
            this.attribute = attribute;
        }

        @Override
        @Nonnull
        public XBAttribute getAttribute() {
            return this.attribute;
        }

        @Override
        public boolean isZero() {
            return this.attribute.isNaturalZero();
        }

        @Override
        @Nonnull
        public XBTTokenType getTokenType() {
            return XBTTokenType.ATTRIBUTE;
        }
    }
}

