/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.XBTokenType;

public abstract class XBDataToken
implements XBToken {
    @Nullable
    private static XBEmptyDataToken instance = null;

    @Nonnull
    public abstract InputStream getData();

    public abstract boolean isEmpty();

    @Override
    @Nonnull
    public XBTokenType getTokenType() {
        return XBTokenType.DATA;
    }

    @Nonnull
    public static XBDataToken create(@Nonnull InputStream data) {
        return new XBDataTokenImpl(data);
    }

    @Nonnull
    public static XBDataToken createEmptyToken() {
        if (instance == null) {
            instance = new XBEmptyDataToken();
        }
        return instance;
    }

    private static class XBEmptyDataToken
    extends XBDataToken {
        XBEmptyDataToken() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @Nonnull
        public InputStream getData() {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    @ParametersAreNonnullByDefault
    private static class XBDataTokenImpl
    extends XBDataToken {
        @Nonnull
        private final InputStream data;

        public XBDataTokenImpl(InputStream data) {
            this.data = data;
        }

        @Override
        @Nonnull
        public XBTokenType getTokenType() {
            return super.getTokenType();
        }

        @Override
        @Nonnull
        public InputStream getData() {
            return this.data;
        }

        @Override
        public boolean isEmpty() {
            try {
                return this.data.available() == 0;
            }
            catch (IOException ex) {
                Logger.getLogger(XBDataToken.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
    }
}

