/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.token;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.parser.token.XBToken;
import org.exbin.xbup.core.parser.token.XBTokenType;

@ParametersAreNonnullByDefault
@Immutable
public abstract class XBBeginToken
implements XBToken {
    private static XBBeginTokenImpl sizeSpecifiedBeginToken = null;
    private static XBBeginTokenImpl terminatedByZeroBeginToken = null;

    @Nonnull
    public abstract XBBlockTerminationMode getTerminationMode();

    @Override
    @Nonnull
    public XBTokenType getTokenType() {
        return XBTokenType.BEGIN;
    }

    @Nonnull
    public static XBBeginToken create(XBBlockTerminationMode terminationMode) {
        switch (terminationMode) {
            case SIZE_SPECIFIED: {
                return XBBeginToken.getSizeSpecifiedInstance();
            }
            case TERMINATED_BY_ZERO: {
                return XBBeginToken.getTerminatedByZeroInstance();
            }
        }
        throw new IllegalStateException("Unexpected termination mode");
    }

    @Nonnull
    public static XBBeginToken getSizeSpecifiedInstance() {
        if (sizeSpecifiedBeginToken == null) {
            sizeSpecifiedBeginToken = new XBBeginTokenImpl(XBBlockTerminationMode.SIZE_SPECIFIED);
        }
        return sizeSpecifiedBeginToken;
    }

    @Nonnull
    public static XBBeginToken getTerminatedByZeroInstance() {
        if (terminatedByZeroBeginToken == null) {
            terminatedByZeroBeginToken = new XBBeginTokenImpl(XBBlockTerminationMode.TERMINATED_BY_ZERO);
        }
        return terminatedByZeroBeginToken;
    }

    @ParametersAreNonnullByDefault
    public static class XBBeginTokenImpl
    extends XBBeginToken {
        @Nonnull
        private final XBBlockTerminationMode terminationMode;

        private XBBeginTokenImpl(XBBlockTerminationMode terminationMode) {
            this.terminationMode = terminationMode;
        }

        @Override
        @Nonnull
        public XBBlockTerminationMode getTerminationMode() {
            return this.terminationMode;
        }
    }
}

