/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.basic.wrapper;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.core.parser.XBParsingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.stream.FinishableStream;

@ParametersAreNonnullByDefault
public class TerminatedDataInputStreamWrapper
extends InputStream
implements FinishableStream {
    private final InputStream source;
    private int zeroCount = 0;
    private long processedLength = 0L;
    private boolean terminated = false;
    private int nextValue = 0;

    public TerminatedDataInputStreamWrapper(InputStream source) throws IOException {
        this.source = source;
        this.nextValue = this.getNextValue();
    }

    @Override
    public int read() throws IOException {
        int next = this.nextValue;
        if (this.nextValue != -1) {
            this.nextValue = this.getNextValue();
        }
        return next;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return super.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return super.read(b);
    }

    @Override
    public long finish() throws IOException, XBParsingException {
        while (!this.terminated) {
            this.read();
        }
        return this.processedLength;
    }

    @Override
    public int available() throws IOException {
        return this.terminated ? 0 : 1;
    }

    @Override
    public long getLength() {
        return this.processedLength;
    }

    private int getNextValue() throws IOException {
        if (this.zeroCount > 0) {
            --this.zeroCount;
            return 0;
        }
        int next = this.source.read();
        if (next == -1) {
            throw new XBParsingException("Missing data block terminator", XBProcessingExceptionType.UNEXPECTED_END_OF_STREAM);
        }
        if (next == 0) {
            this.zeroCount = this.source.read();
            if (this.zeroCount < 0) {
                throw new XBParsingException("Missing data block terminator", XBProcessingExceptionType.UNEXPECTED_END_OF_STREAM);
            }
            if (this.zeroCount == 0) {
                this.processedLength += 2L;
                this.terminated = true;
                return -1;
            }
            this.processedLength += 2L;
            --this.zeroCount;
            return 0;
        }
        ++this.processedLength;
        return next;
    }
}

