/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.basic.convert;

import java.io.IOException;
import java.io.InputStream;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.basic.XBListener;
import org.exbin.xbup.core.parser.basic.XBSListener;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.basic.XBTProducer;
import org.exbin.xbup.core.parser.basic.XBTSListener;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.ubnumber.UBNatural;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

public class XBToXBTConvertor
implements XBListener,
XBSListener,
XBTProducer {
    private XBTListener listener;
    private boolean blockTypeProcessed = true;
    private UBNatural groupId;

    public XBToXBTConvertor(XBTListener listener) {
        this.listener = listener;
    }

    @Override
    public void beginXB(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
        if (!this.blockTypeProcessed) {
            this.listener.typeXBT(new XBFixedBlockType(this.groupId != null ? this.groupId.getLong() : 0L, 0L));
        }
        this.listener.beginXBT(terminationMode);
        this.blockTypeProcessed = false;
        this.groupId = null;
    }

    @Override
    public void beginXB(XBBlockTerminationMode terminationMode, UBNatural blockSize) throws XBProcessingException, IOException {
        if (!this.blockTypeProcessed) {
            this.listener.typeXBT(new XBFixedBlockType(this.groupId != null ? this.groupId.getLong() : 0L, 0L));
        }
        if (this.listener instanceof XBTSListener) {
            ((XBTSListener)this.listener).beginXBT(terminationMode, blockSize);
        } else {
            this.listener.beginXBT(terminationMode);
        }
        this.blockTypeProcessed = false;
        this.groupId = null;
    }

    @Override
    public void attribXB(XBAttribute value) throws XBProcessingException, IOException {
        if (this.blockTypeProcessed) {
            this.listener.attribXBT(value);
        } else if (this.groupId != null) {
            this.listener.typeXBT(new XBFixedBlockType(this.groupId.getLong(), value.getNaturalLong()));
            this.blockTypeProcessed = true;
        } else {
            this.groupId = new UBNat32(value.getNaturalLong());
        }
    }

    @Override
    public void dataXB(InputStream data) throws XBProcessingException, IOException {
        if (!this.blockTypeProcessed && this.groupId != null) {
            this.listener.typeXBT(new XBFixedBlockType(this.groupId != null ? this.groupId.getLong() : 0L, 0L));
        }
        this.listener.dataXBT(data);
        this.blockTypeProcessed = true;
    }

    @Override
    public void endXB() throws XBProcessingException, IOException {
        if (!this.blockTypeProcessed) {
            this.listener.typeXBT(new XBFixedBlockType(this.groupId != null ? this.groupId.getLong() : 0L, 0L));
            this.blockTypeProcessed = true;
        }
        this.listener.endXBT();
    }

    @Override
    public void attachXBTListener(XBTListener listener) {
        this.listener = listener;
    }
}

