/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.parser.basic.convert;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.parser.XBProcessingExceptionType;
import org.exbin.xbup.core.parser.basic.XBTListener;
import org.exbin.xbup.core.parser.basic.XBTProducer;
import org.exbin.xbup.core.parser.basic.XBTProvider;
import org.exbin.xbup.core.parser.basic.XBTSListener;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.parser.token.XBTAttributeToken;
import org.exbin.xbup.core.parser.token.XBTBeginToken;
import org.exbin.xbup.core.parser.token.XBTDataToken;
import org.exbin.xbup.core.parser.token.XBTEndToken;
import org.exbin.xbup.core.parser.token.XBTSBeginToken;
import org.exbin.xbup.core.parser.token.XBTToken;
import org.exbin.xbup.core.parser.token.XBTTypeToken;
import org.exbin.xbup.core.parser.token.convert.XBTListenerToToken;
import org.exbin.xbup.core.ubnumber.UBNatural;

public class XBTProducerToProvider
implements XBTProvider {
    private List<XBTToken> tokens = new ArrayList<XBTToken>();

    public XBTProducerToProvider(XBTProducer producer) {
        producer.attachXBTListener(new XBTSListener(){

            @Override
            public void beginXBT(XBBlockTerminationMode terminationMode) throws XBProcessingException, IOException {
                XBTProducerToProvider.this.tokens.add(XBTBeginToken.create(terminationMode));
            }

            @Override
            public void beginXBT(XBBlockTerminationMode terminationMode, UBNatural blockSize) throws XBProcessingException, IOException {
                XBTProducerToProvider.this.tokens.add(XBTSBeginToken.create(terminationMode, blockSize));
            }

            @Override
            public void typeXBT(XBBlockType type) throws XBProcessingException, IOException {
                XBTProducerToProvider.this.tokens.add(XBTTypeToken.create(type));
            }

            @Override
            public void attribXBT(XBAttribute value) throws XBProcessingException, IOException {
                XBTProducerToProvider.this.tokens.add(XBTAttributeToken.create(value));
            }

            @Override
            public void dataXBT(InputStream data) throws XBProcessingException, IOException {
                XBTProducerToProvider.this.tokens.add(XBTDataToken.create(data));
            }

            @Override
            public void endXBT() throws XBProcessingException, IOException {
                XBTProducerToProvider.this.tokens.add(XBTEndToken.create());
            }
        });
    }

    @Override
    public void produceXBT(XBTListener listener) throws XBProcessingException, IOException {
        if (!this.tokens.isEmpty()) {
            throw new XBProcessingException("End of data reached", XBProcessingExceptionType.UNEXPECTED_END_OF_STREAM);
        }
        XBTToken token = this.tokens.get(0);
        XBTListenerToToken.tokenToListener(token, listener);
    }
}

