/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block.definition.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.exbin.xbup.core.block.XBBasicBlockType;
import org.exbin.xbup.core.block.XBFixedBlockType;
import org.exbin.xbup.core.block.declaration.catalog.XBCFormatDecl;
import org.exbin.xbup.core.block.declaration.catalog.XBCGroupDecl;
import org.exbin.xbup.core.block.definition.XBFormatDef;
import org.exbin.xbup.core.block.definition.XBFormatParam;
import org.exbin.xbup.core.block.definition.XBFormatParamConsist;
import org.exbin.xbup.core.block.definition.XBFormatParamJoin;
import org.exbin.xbup.core.block.definition.XBRevisionDef;
import org.exbin.xbup.core.block.definition.catalog.XBCRevisionDef;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCFormatRev;
import org.exbin.xbup.core.catalog.base.XBCFormatSpec;
import org.exbin.xbup.core.catalog.base.XBCGroupRev;
import org.exbin.xbup.core.catalog.base.XBCSpecDef;
import org.exbin.xbup.core.catalog.base.service.XBCSpecService;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPInputSerialHandler;
import org.exbin.xbup.core.serial.param.XBPOutputSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerialHandler;
import org.exbin.xbup.core.serial.param.XBPSequenceSerializable;
import org.exbin.xbup.core.serial.param.XBPSerializable;
import org.exbin.xbup.core.serial.sequence.XBListConsistSerializable;
import org.exbin.xbup.core.ubnumber.UBENatural;
import org.exbin.xbup.core.ubnumber.type.UBENat32;

public class XBCFormatDef
implements XBFormatDef,
XBPSequenceSerializable {
    private final XBCatalog catalog;
    private final XBCFormatSpec formatSpec;

    public XBCFormatDef(XBCatalog catalog, XBCFormatSpec formatSpec) {
        this.catalog = catalog;
        this.formatSpec = formatSpec;
    }

    @Override
    public List<XBFormatParam> getFormatParams() {
        XBCSpecService specService = this.catalog.getCatalogService(XBCSpecService.class);
        ArrayList<XBFormatParam> resultList = new ArrayList<XBFormatParam>();
        List<XBCSpecDef> specDefs = specService.getSpecDefs(this.formatSpec);
        for (XBCSpecDef specDef : specDefs) {
            resultList.add(this.convertParam(specDef));
        }
        return resultList;
    }

    @Override
    public XBRevisionDef getRevisionDef() {
        return new XBCRevisionDef(this.catalog, this.formatSpec);
    }

    @Override
    public XBFormatParam getFormatParam(int paramIndex) {
        XBCSpecService specService = this.catalog.getCatalogService(XBCSpecService.class);
        XBCSpecDef specDef = specService.findSpecDefByXB(this.formatSpec, paramIndex);
        if (specDef == null) {
            return null;
        }
        return this.convertParam(specDef);
    }

    @Override
    public long getParamsCount() {
        XBCSpecService specService = this.catalog.getCatalogService(XBCSpecService.class);
        return specService.findMaxSpecDefXB(this.formatSpec);
    }

    public XBFormatParam convertParam(XBCSpecDef specDef) {
        switch (specDef.getType()) {
            case CONSIST: {
                return new XBFormatParamConsist(new XBCGroupDecl((XBCGroupRev)specDef.getTargetRev().get(), this.catalog));
            }
            case JOIN: {
                return new XBFormatParamJoin(new XBCFormatDecl((XBCFormatRev)specDef.getTargetRev().get(), this.catalog));
            }
        }
        throw new IllegalStateException("Unexpected specification definition type");
    }

    @Override
    public void serializeXB(XBPSequenceSerialHandler serial) throws XBProcessingException, IOException {
        serial.begin();
        serial.matchType(new XBFixedBlockType(XBBasicBlockType.FORMAT_DEFINITION));
        serial.join(new XBCRevisionDef(this.catalog, this.formatSpec));
        serial.listConsist(new XBListConsistSerializable(){
            private int position = 0;

            @Override
            public UBENatural getSize() {
                XBCSpecService specService = XBCFormatDef.this.catalog.getCatalogService(XBCSpecService.class);
                return new UBENat32(specService.findMaxSpecDefXB(XBCFormatDef.this.formatSpec));
            }

            @Override
            public void setSize(UBENatural count) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void reset() {
                this.position = 0;
            }

            @Override
            public XBSerializable next() {
                return new XBPSerializable(){

                    @Override
                    public void serializeFromXB(XBPInputSerialHandler serializationHandler) throws XBProcessingException, IOException {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }

                    @Override
                    public void serializeToXB(XBPOutputSerialHandler serializationHandler) throws XBProcessingException, IOException {
                        XBFormatParam param = XBCFormatDef.this.getFormatParam(position);
                        if (param instanceof XBFormatParamConsist) {
                            serializationHandler.append((XBFormatParamConsist)param);
                        } else if (param instanceof XBFormatParamJoin) {
                            serializationHandler.append((XBFormatParamJoin)param);
                        } else {
                            throw new IllegalStateException("Illegal format parameter " + position);
                        }
                    }
                };
            }
        });
        serial.end();
    }
}

