/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block;

import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.xbup.core.block.XBBlock;
import org.exbin.xbup.core.block.XBBlockDataMode;
import org.exbin.xbup.core.block.XBBlockTerminationMode;
import org.exbin.xbup.core.block.XBEditableBlock;
import org.exbin.xbup.core.parser.token.XBAttribute;
import org.exbin.xbup.core.type.XBData;

@ParametersAreNonnullByDefault
public class XBDefaultBlock
implements XBBlock {
    @Nullable
    private XBBlock parent;
    @Nonnull
    private final XBBlockDataMode dataMode;
    @Nonnull
    private final XBBlockTerminationMode terminationMode;
    @Nullable
    private final XBAttribute[] attributes;
    @Nullable
    private final XBBlock[] children;
    @Nullable
    private final BinaryData data;

    public XBDefaultBlock() {
        this(null, XBBlockTerminationMode.SIZE_SPECIFIED, (BinaryData)new XBData());
    }

    public XBDefaultBlock(@Nullable XBBlock parent, @Nullable XBBlockTerminationMode terminationMode, @Nullable BinaryData data) {
        this.dataMode = XBBlockDataMode.DATA_BLOCK;
        this.parent = parent;
        this.terminationMode = terminationMode;
        this.attributes = null;
        this.children = null;
        this.data = data == null ? new XBData() : data;
    }

    public XBDefaultBlock(@Nullable XBBlockTerminationMode terminationMode, @Nullable BinaryData data) {
        this(null, terminationMode, data);
    }

    public XBDefaultBlock(@Nullable XBBlock parent, @Nullable XBBlockTerminationMode terminationMode, @Nullable XBAttribute[] attributes, @Nullable XBBlock[] children) {
        this.dataMode = XBBlockDataMode.NODE_BLOCK;
        this.parent = parent;
        this.terminationMode = terminationMode == null ? XBBlockTerminationMode.SIZE_SPECIFIED : terminationMode;
        this.attributes = attributes == null ? new XBAttribute[]{} : attributes;
        this.children = children == null ? new XBBlock[]{} : children;
        this.data = null;
        if (children != null) {
            this.attachChildren(children);
        }
    }

    public XBDefaultBlock(@Nullable XBBlockTerminationMode terminationMode, @Nullable XBAttribute[] attributes, @Nullable XBBlock[] children) {
        this(null, terminationMode, attributes, children);
    }

    private void attachChildren(XBBlock[] children) {
        for (XBBlock child : children) {
            if (child instanceof XBDefaultBlock) {
                ((XBDefaultBlock)child).setParent(this);
                continue;
            }
            if (!(child instanceof XBEditableBlock)) continue;
            ((XBEditableBlock)child).setParent(this);
        }
    }

    @Override
    @Nonnull
    public Optional<XBBlock> getParentBlock() {
        return Optional.ofNullable(this.parent);
    }

    public void setParent(@Nullable XBBlock parent) {
        this.parent = parent;
    }

    @Override
    @Nonnull
    public XBBlockDataMode getDataMode() {
        return this.dataMode;
    }

    @Override
    @Nonnull
    public XBBlockTerminationMode getTerminationMode() {
        return this.terminationMode;
    }

    @Override
    @Nullable
    public XBAttribute[] getAttributes() {
        return this.attributes;
    }

    @Override
    @Nullable
    public XBAttribute getAttributeAt(int attributeIndex) {
        return this.attributes[attributeIndex];
    }

    @Override
    public int getAttributesCount() {
        return this.attributes == null ? 0 : this.attributes.length;
    }

    @Override
    public XBBlock[] getChildren() {
        return this.children;
    }

    @Override
    @Nullable
    public XBBlock getChildAt(int childIndex) {
        return this.children[childIndex];
    }

    @Override
    public int getChildrenCount() {
        return this.children.length;
    }

    @Override
    @Nonnull
    public InputStream getData() {
        return this.data.getDataInputStream();
    }

    @Override
    @Nonnull
    public BinaryData getBlockData() {
        return Objects.requireNonNull(this.data);
    }

    public long getDataSize() {
        return this.data == null ? 0L : this.data.getDataSize();
    }

    public static int getBlockIndex(@Nullable XBBlock block) {
        if (block == null) {
            return -1;
        }
        Optional<XBBlock> blockParent = block.getParentBlock();
        if (blockParent.isPresent()) {
            XBBlock child;
            int result = XBDefaultBlock.getBlockIndex(blockParent.get()) + 1;
            int childIndex = 0;
            do {
                if (block.equals(child = blockParent.get().getChildAt(childIndex))) {
                    return result + childIndex;
                }
                ++childIndex;
            } while (child != null);
            return result;
        }
        return 0;
    }

    public static int getChildIndexOf(XBBlock parent, XBBlock block) {
        XBBlock child;
        if (block == null || parent == null) {
            return -1;
        }
        Optional<XBBlock> blockParent = block.getParentBlock();
        if (!blockParent.isPresent()) {
            return -1;
        }
        int childIndex = 0;
        do {
            if (block.equals(child = blockParent.get().getChildAt(childIndex))) {
                return childIndex;
            }
            ++childIndex;
        } while (child != null);
        return -1;
    }
}

