/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.core.block;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public enum XBBasicBlockType {
    UNKNOWN_BLOCK(0),
    DECLARATION(1),
    FORMAT_DECLARATION(2),
    FORMAT_DEFINITION(3),
    FORMAT_JOIN_PARAMETER(4),
    FORMAT_CONSIST_PARAMETER(5),
    GROUP_DECLARATION(6),
    GROUP_DEFINITION(7),
    GROUP_JOIN_PARAMETER(8),
    GROUP_CONSIST_PARAMETER(9),
    BLOCK_DECLARATION(10),
    BLOCK_DEFINITION(11),
    BLOCK_JOIN_PARAMETER(12),
    BLOCK_CONSIST_PARAMETER(13),
    BLOCK_LIST_JOIN_PARAMETER(14),
    BLOCK_LIST_CONSIST_PARAMETER(15),
    REVISION_DEFINITION(16),
    REVISION_PARAMETER(17);

    private final int blockId;
    @Nonnull
    private static final Map<Integer, XBBasicBlockType> map;
    private static final int size;

    private XBBasicBlockType(int blockId) {
        this.blockId = blockId;
    }

    public int getBlockId() {
        return this.blockId;
    }

    @Nonnull
    public static XBBasicBlockType valueOf(int blockId) {
        return map.get(blockId);
    }

    public static int getSize() {
        return size;
    }

    static {
        map = new HashMap<Integer, XBBasicBlockType>();
        for (XBBasicBlockType blockType : XBBasicBlockType.values()) {
            map.put(blockType.blockId, blockType);
        }
        size = XBBasicBlockType.values().length;
    }
}

