/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.action.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicArrowButton;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class DropDownButtonPanel
extends JPanel {
    private JLabel actionLabel;
    private JButton menuButton;

    public DropDownButtonPanel() {
        this.initComponents();
        this.actionLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                this.passMouseEventToParent(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.passMouseEventToParent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.passMouseEventToParent(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.passMouseEventToParent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.passMouseEventToParent(e);
            }

            private void passMouseEventToParent(MouseEvent me) {
                Container parent = DropDownButtonPanel.this.getParent();
                parent.dispatchEvent(SwingUtilities.convertMouseEvent(DropDownButtonPanel.this.actionLabel, me, parent));
            }
        });
    }

    @Nonnull
    public JLabel getActionButton() {
        return this.actionLabel;
    }

    @Nonnull
    public JButton getMenuButton() {
        return this.menuButton;
    }

    private void initComponents() {
        this.menuButton = new BasicArrowButton(5);
        this.actionLabel = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setFocusable(false);
        this.setOpaque(false);
        this.menuButton.setBorderPainted(false);
        this.menuButton.setFocusable(false);
        this.menuButton.setMargin(new Insets(0, 0, 0, 0));
        this.menuButton.setMaximumSize(new Dimension(15, 100));
        this.menuButton.setOpaque(false);
        this.actionLabel.setFocusable(false);
        this.actionLabel.setVerifyInputWhenFocusTarget(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.actionLabel).addGap(0, 0, 0).addComponent(this.menuButton, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.menuButton, -1, -1, Short.MAX_VALUE).addComponent(this.actionLabel, -1, -1, Short.MAX_VALUE));
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new DropDownButtonPanel());
    }
}

