/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.action;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.exbin.framework.action.MenuDefinition;
import org.exbin.framework.action.api.ActionMenuContribution;
import org.exbin.framework.action.api.DirectMenuContribution;
import org.exbin.framework.action.api.MenuContribution;
import org.exbin.framework.action.api.MenuGroup;
import org.exbin.framework.action.api.MenuPosition;
import org.exbin.framework.action.api.NextToMode;
import org.exbin.framework.action.api.PositionMode;
import org.exbin.framework.action.api.SeparationMode;
import org.exbin.framework.action.api.SubMenuContribution;
import org.exbin.framework.utils.ActionUtils;

@ParametersAreNonnullByDefault
public class MenuHandler {
    private Map<String, MenuDefinition> menus = new HashMap<String, MenuDefinition>();
    private Map<String, List<MenuGroup>> menuGroups = new HashMap<String, List<MenuGroup>>();
    private Set<String> menuModified = new HashSet<String>();
    private Map<String, String> pluginsUsage = new HashMap<String, String>();

    public void buildMenu(JMenu targetMenu, String menuId) {
        this.buildMenu(new MenuWrapper(targetMenu), menuId);
    }

    public void buildMenu(JPopupMenu targetMenu, String menuId) {
        this.buildMenu(new PopupMenuWrapper(targetMenu), menuId);
    }

    private void buildMenu(MenuTarget targetMenu, String menuId) {
        MenuDefinition menuDef = this.menus.get(menuId);
        if (menuDef == null) {
            return;
        }
        HashMap<String, List<MenuContribution>> beforeItem = new HashMap<String, List<MenuContribution>>();
        HashMap<String, List<MenuContribution>> afterItem = new HashMap<String, List<MenuContribution>>();
        LinkedList<MenuGroupRecord> groupRecords = new LinkedList<MenuGroupRecord>();
        HashMap<String, MenuGroupRecord> groupsMap = new HashMap<String, MenuGroupRecord>();
        for (PositionMode mode : PositionMode.values()) {
            MenuGroupRecord menuGroupRecord = new MenuGroupRecord(mode.name());
            groupsMap.put(mode.name(), menuGroupRecord);
            groupRecords.add(menuGroupRecord);
        }
        List<MenuGroup> groups = this.menuGroups.get(menuId);
        if (groups != null) {
            for (MenuGroup group : groups) {
                MenuGroupRecord menuGroupRecord;
                MenuGroupRecord groupRecord;
                String groupId = group.getGroupId();
                SeparationMode separationMode = group.getSeparationMode();
                MenuPosition position = group.getPosition();
                PositionMode basicMode = position.getBasicMode();
                if (basicMode != null) {
                    groupRecord = (MenuGroupRecord)groupsMap.get(basicMode.name());
                    menuGroupRecord = new MenuGroupRecord(groupId);
                    menuGroupRecord.separationMode = separationMode;
                    groupRecord.subGroups.add(menuGroupRecord);
                    groupsMap.put(groupId, menuGroupRecord);
                    continue;
                }
                groupRecord = (MenuGroupRecord)groupsMap.get(position.getGroupId());
                menuGroupRecord = new MenuGroupRecord(groupId);
                menuGroupRecord.separationMode = separationMode;
                groupRecord.subGroups.add(menuGroupRecord);
                groupsMap.put(groupId, menuGroupRecord);
            }
        }
        block6: for (MenuContribution contribution : menuDef.getContributions()) {
            MenuGroupRecord menuGroupRecord;
            MenuPosition menuPosition = contribution.getMenuPosition();
            PositionMode basicMode = menuPosition.getBasicMode();
            NextToMode nextToMode = menuPosition.getNextToMode();
            if (basicMode != null) {
                menuGroupRecord = (MenuGroupRecord)groupsMap.get(basicMode.name());
                menuGroupRecord.contributions.add(contribution);
                continue;
            }
            if (nextToMode != null) {
                switch (nextToMode) {
                    case BEFORE: {
                        LinkedList<MenuContribution> contributions = (LinkedList<MenuContribution>)beforeItem.get(menuPosition.getGroupId());
                        if (contributions == null) {
                            contributions = new LinkedList<MenuContribution>();
                            beforeItem.put(menuPosition.getGroupId(), contributions);
                        }
                        contributions.add(contribution);
                        continue block6;
                    }
                    case AFTER: {
                        LinkedList<MenuContribution> contributions = (List)afterItem.get(menuPosition.getGroupId());
                        if (contributions == null) {
                            contributions = new LinkedList();
                            afterItem.put(menuPosition.getGroupId(), contributions);
                        }
                        contributions.add(contribution);
                        continue block6;
                    }
                }
                throw new IllegalStateException();
            }
            menuGroupRecord = (MenuGroupRecord)groupsMap.get(menuPosition.getGroupId());
            menuGroupRecord.contributions.add(contribution);
        }
        HashMap<String, ButtonGroup> buttonGroups = new HashMap<String, ButtonGroup>();
        this.processMenuGroup(groupRecords, beforeItem, afterItem, targetMenu, buttonGroups, menuId);
    }

    private void processMenuGroup(List<MenuGroupRecord> groups, Map<String, List<MenuContribution>> beforeItem, Map<String, List<MenuContribution>> afterItem, final MenuTarget targetMenu, final Map<String, ButtonGroup> buttonGroups, final String menuId) {
        LinkedList<MenuGroupRecordPathNode> processingPath = new LinkedList<MenuGroupRecordPathNode>();
        processingPath.add(new MenuGroupRecordPathNode(groups));
        boolean separatorQueued = false;
        boolean itemsAdded = false;
        while (!processingPath.isEmpty()) {
            MenuGroupRecordPathNode pathNode = (MenuGroupRecordPathNode)processingPath.get(processingPath.size() - 1);
            if (pathNode.childIndex == pathNode.records.size()) {
                processingPath.remove(processingPath.size() - 1);
                continue;
            }
            MenuGroupRecord groupRecord = pathNode.records.get(pathNode.childIndex);
            ++pathNode.childIndex;
            if (itemsAdded && (groupRecord.separationMode == SeparationMode.ABOVE || groupRecord.separationMode == SeparationMode.AROUND)) {
                itemsAdded = false;
                separatorQueued = true;
            }
            for (MenuContribution contribution : groupRecord.contributions) {
                LinkedList<QueuedContribution> queue = new LinkedList<QueuedContribution>();
                queue.add(new QueuedContribution(null, contribution));
                ProcessedContribution rootProcessed = null;
                while (!queue.isEmpty()) {
                    List<MenuContribution> nextToAfter;
                    List<MenuContribution> nextToBefore;
                    ProcessedContribution processed;
                    final QueuedContribution next = (QueuedContribution)queue.remove(0);
                    if (next.contribution instanceof ActionMenuContribution) {
                        processed = new ProcessedContribution(){
                            JMenuItem menuItem;

                            @Override
                            public void process() {
                                Action action = ((ActionMenuContribution)next.contribution).getAction();
                                this.menuItem = ActionUtils.actionToMenuItem((Action)action, (Map)buttonGroups);
                            }

                            @Override
                            public String getName() {
                                return this.menuItem.getText();
                            }

                            @Override
                            public boolean shouldCreate() {
                                Action action;
                                ActionUtils.MenuCreation menuCreation;
                                if (targetMenu.isPopup() && (menuCreation = (ActionUtils.MenuCreation)(action = ((ActionMenuContribution)next.contribution).getAction()).getValue("menu_creation")) != null) {
                                    return menuCreation.shouldCreate(menuId);
                                }
                                return true;
                            }

                            @Override
                            public void finish() {
                                Action action;
                                ActionUtils.MenuCreation menuCreation;
                                if (targetMenu.isPopup() && (menuCreation = (ActionUtils.MenuCreation)(action = ((ActionMenuContribution)next.contribution).getAction()).getValue("menu_creation")) != null) {
                                    menuCreation.onCreate(this.menuItem, menuId);
                                }
                                targetMenu.add(this.menuItem);
                            }
                        };
                    } else if (next.contribution instanceof SubMenuContribution) {
                        processed = new ProcessedContribution(){
                            JMenu subMenu;

                            @Override
                            public void process() {
                                SubMenuContribution subMenuContribution = (SubMenuContribution)next.contribution;
                                this.subMenu = new JMenu(subMenuContribution.getAction());
                                MenuHandler.this.buildMenu(new MenuWrapper(this.subMenu, targetMenu.isPopup()), subMenuContribution.getMenuId());
                            }

                            @Override
                            public String getName() {
                                return this.subMenu.getText();
                            }

                            @Override
                            public boolean shouldCreate() {
                                ActionUtils.MenuCreation menuCreation;
                                Action action;
                                if (targetMenu.isPopup() && (action = this.subMenu.getAction()) != null && (menuCreation = (ActionUtils.MenuCreation)action.getValue("menu_creation")) != null) {
                                    return menuCreation.shouldCreate(menuId);
                                }
                                return this.subMenu.getMenuComponentCount() > 0;
                            }

                            @Override
                            public void finish() {
                                ActionUtils.MenuCreation menuCreation;
                                Action action;
                                if (targetMenu.isPopup() && (action = this.subMenu.getAction()) != null && (menuCreation = (ActionUtils.MenuCreation)action.getValue("menu_creation")) != null) {
                                    menuCreation.onCreate((JMenuItem)this.subMenu, menuId);
                                }
                                targetMenu.add(this.subMenu);
                            }
                        };
                    } else if (next.contribution instanceof DirectMenuContribution) {
                        processed = new ProcessedContribution(){
                            DirectMenuContribution directMenuContribution;

                            @Override
                            public void process() {
                                this.directMenuContribution = (DirectMenuContribution)next.contribution;
                            }

                            @Override
                            public String getName() {
                                return this.directMenuContribution.getMenu().getName();
                            }

                            @Override
                            public boolean shouldCreate() {
                                ActionUtils.MenuCreation menuCreation;
                                Action action;
                                if (targetMenu.isPopup() && (action = this.directMenuContribution.getMenu().getAction()) != null && (menuCreation = (ActionUtils.MenuCreation)action.getValue("menu_creation")) != null) {
                                    return menuCreation.shouldCreate(menuId);
                                }
                                return true;
                            }

                            @Override
                            public void finish() {
                                ActionUtils.MenuCreation menuCreation;
                                Action action;
                                JMenu menuItem = this.directMenuContribution.getMenu();
                                if (targetMenu.isPopup() && (action = this.directMenuContribution.getMenu().getAction()) != null && (menuCreation = (ActionUtils.MenuCreation)action.getValue("menu_creation")) != null) {
                                    menuCreation.onCreate((JMenuItem)menuItem, menuId);
                                }
                                targetMenu.add(menuItem);
                            }
                        };
                    } else {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                    processed.process();
                    if (next.parent == null) {
                        rootProcessed = processed;
                    }
                    String name = processed.getName();
                    NextToMode nextToMode = next.contribution.getMenuPosition().getNextToMode();
                    if (nextToMode != null) {
                        switch (nextToMode) {
                            case BEFORE: {
                                next.parent.before.add(processed);
                                break;
                            }
                            case AFTER: {
                                next.parent.after.add(processed);
                                break;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                    }
                    if ((nextToBefore = beforeItem.get(name)) != null) {
                        nextToBefore.forEach(menuContribution -> queue.add(new QueuedContribution(processed, (MenuContribution)menuContribution)));
                    }
                    if ((nextToAfter = afterItem.get(name)) == null) continue;
                    nextToAfter.forEach(menuContribution -> queue.add(new QueuedContribution(processed, (MenuContribution)menuContribution)));
                }
                LinkedList<OrderingContribution> orderingPath = new LinkedList<OrderingContribution>();
                orderingPath.add(new OrderingContribution(OrderingMode.BEFORE, rootProcessed));
                block12: while (!orderingPath.isEmpty()) {
                    OrderingContribution orderingContribution = (OrderingContribution)orderingPath.get(orderingPath.size() - 1);
                    switch (orderingContribution.mode) {
                        case BEFORE: {
                            if (orderingContribution.processed.before.isEmpty()) {
                                orderingContribution.mode = OrderingMode.ITEM;
                                continue block12;
                            }
                            orderingPath.add(new OrderingContribution(OrderingMode.BEFORE, orderingContribution.processed.before.remove(0)));
                            continue block12;
                        }
                        case ITEM: {
                            boolean itemAdded = orderingContribution.processed.shouldCreate();
                            if (itemAdded) {
                                if (separatorQueued) {
                                    targetMenu.addSeparator();
                                    separatorQueued = false;
                                }
                                orderingContribution.processed.finish();
                            }
                            itemsAdded |= itemAdded;
                            orderingContribution.mode = OrderingMode.AFTER;
                            continue block12;
                        }
                        case AFTER: {
                            if (orderingContribution.processed.after.isEmpty()) {
                                orderingPath.remove(orderingPath.size() - 1);
                                continue block12;
                            }
                            orderingPath.add(new OrderingContribution(OrderingMode.BEFORE, orderingContribution.processed.after.remove(0)));
                            continue block12;
                        }
                    }
                    throw new IllegalStateException();
                }
            }
            if (itemsAdded && groupRecord.separationMode == SeparationMode.AROUND || groupRecord.separationMode == SeparationMode.BELOW) {
                itemsAdded = false;
                separatorQueued = true;
            }
            if (groupRecord.subGroups.isEmpty()) continue;
            processingPath.add(new MenuGroupRecordPathNode(groupRecord.subGroups));
        }
    }

    boolean menuGroupExists(String menuId, String groupId) {
        List<MenuGroup> menuGroupDefs = this.menuGroups.get(menuId);
        if (menuGroupDefs == null) {
            return false;
        }
        return menuGroupDefs.stream().anyMatch(menuGroup -> groupId.equals(menuGroup.getGroupId()));
    }

    public void unregisterMenu(String menuId) {
        MenuDefinition definition = this.menus.get(menuId);
        if (definition != null) {
            for (Map.Entry<String, List<MenuGroup>> entry : this.menuGroups.entrySet()) {
                if (!menuId.equals(entry.getKey())) continue;
                this.menuGroups.remove(entry.getKey());
                break;
            }
            for (Map.Entry<String, Object> entry : this.pluginsUsage.entrySet()) {
                if (!menuId.equals(entry.getValue())) continue;
                this.pluginsUsage.remove(entry.getKey());
                break;
            }
            this.menus.remove(menuId);
        }
    }

    public void buildMenu(JMenuBar targetMenuBar, String menuId) {
        this.buildMenu(new MenuBarWrapper(targetMenuBar), menuId);
    }

    public void registerMenu(String menuId, String pluginId) {
        if (menuId == null) {
            throw new NullPointerException("Menu Id cannot be null");
        }
        if (pluginId == null) {
            throw new NullPointerException("Plugin Id cannot be null");
        }
        MenuDefinition menu = this.menus.get(menuId);
        if (menu != null) {
            throw new IllegalStateException("Menu with ID " + menuId + " already exists.");
        }
        MenuDefinition menuDefinition = new MenuDefinition(pluginId);
        this.menus.put(menuId, menuDefinition);
    }

    public void registerMenuGroup(String menuId, MenuGroup menuGroup) {
        List<MenuGroup> groups = this.menuGroups.get(menuId);
        if (groups == null) {
            groups = new LinkedList<MenuGroup>();
            this.menuGroups.put(menuId, groups);
        }
        groups.add(menuGroup);
    }

    public void registerMenuItem(String menuId, String pluginId, Action action, MenuPosition position) {
        MenuDefinition menuDef = this.menus.get(menuId);
        if (menuDef == null) {
            throw new IllegalStateException("Menu with Id " + menuId + " doesn't exist");
        }
        ActionMenuContribution menuContribution = new ActionMenuContribution(action, position);
        menuDef.getContributions().add((MenuContribution)menuContribution);
    }

    public void registerMenuItem(String menuId, String pluginId, String subMenuId, String subMenuName, MenuPosition position) {
        AbstractAction subMenuAction = new AbstractAction(subMenuName){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.registerMenuItem(menuId, pluginId, subMenuId, subMenuAction, position);
    }

    public void registerMenuItem(String menuId, String pluginId, String subMenuId, Action subMenuAction, MenuPosition position) {
        MenuDefinition menuDef = this.menus.get(menuId);
        if (menuDef == null) {
            throw new IllegalStateException("Menu with Id " + menuId + " doesn't exist");
        }
        SubMenuContribution menuContribution = new SubMenuContribution(subMenuId, subMenuAction, position);
        menuDef.getContributions().add((MenuContribution)menuContribution);
    }

    public void registerMenuItem(String menuId, String pluginId, JMenu menu, MenuPosition position) {
        MenuDefinition menuDef = this.menus.get(menuId);
        if (menuDef == null) {
            throw new IllegalStateException("Menu with Id " + menuId + " doesn't exist");
        }
        DirectMenuContribution menuContribution = new DirectMenuContribution(menu, position);
        menuDef.getContributions().add((MenuContribution)menuContribution);
    }

    @ParametersAreNonnullByDefault
    private static class MenuWrapper
    implements MenuTarget {
        private final JMenu menu;
        private final boolean popup;

        public MenuWrapper(JMenu menu, boolean popup) {
            this.menu = menu;
            this.popup = popup;
        }

        public MenuWrapper(JMenu menu) {
            this.menu = menu;
            this.popup = false;
        }

        @Override
        public void add(JMenu menuItem) {
            this.menu.add(menuItem);
        }

        @Override
        public void add(JMenuItem menuItem) {
            this.menu.add(menuItem);
        }

        @Override
        public void addSeparator() {
            this.menu.addSeparator();
        }

        @Override
        public boolean isPopup() {
            return this.popup;
        }
    }

    @ParametersAreNonnullByDefault
    private static class PopupMenuWrapper
    implements MenuTarget {
        private final JPopupMenu menu;

        public PopupMenuWrapper(JPopupMenu menu) {
            this.menu = menu;
        }

        @Override
        public void add(JMenu menuItem) {
            this.menu.add(menuItem);
        }

        @Override
        public void add(JMenuItem menuItem) {
            this.menu.add(menuItem);
        }

        @Override
        public void addSeparator() {
            this.menu.addSeparator();
        }

        @Override
        public boolean isPopup() {
            return true;
        }
    }

    @ParametersAreNonnullByDefault
    private static class MenuBarWrapper
    implements MenuTarget {
        private final JMenuBar menuBar;

        public MenuBarWrapper(JMenuBar menuBar) {
            this.menuBar = menuBar;
        }

        @Override
        public void add(JMenu menuItem) {
            this.menuBar.add(menuItem);
        }

        @Override
        public void add(JMenuItem menuItem) {
            this.menuBar.add(menuItem);
        }

        @Override
        public void addSeparator() {
        }

        @Override
        public boolean isPopup() {
            return false;
        }
    }

    @ParametersAreNonnullByDefault
    private static interface MenuTarget {
        public void add(JMenu var1);

        public void add(JMenuItem var1);

        public void addSeparator();

        public boolean isPopup();
    }

    @ParametersAreNonnullByDefault
    private class MenuGroupRecordPathNode {
        List<MenuGroupRecord> records;
        int childIndex;

        public MenuGroupRecordPathNode(List<MenuGroupRecord> records) {
            this.records = records;
        }
    }

    @ParametersAreNonnullByDefault
    private class MenuGroupRecord {
        String groupId;
        SeparationMode separationMode;
        List<MenuGroupRecord> subGroups = new LinkedList<MenuGroupRecord>();
        List<MenuContribution> contributions = new LinkedList<MenuContribution>();

        public MenuGroupRecord(String groupId) {
            this.groupId = groupId;
        }

        public MenuGroupRecord(String groupId, SeparationMode separationMode) {
            this(groupId);
            this.separationMode = separationMode;
        }
    }

    private static enum OrderingMode {
        BEFORE,
        ITEM,
        AFTER;

    }

    private static class OrderingContribution {
        OrderingMode mode;
        ProcessedContribution processed;

        public OrderingContribution(OrderingMode mode, ProcessedContribution processed) {
            this.mode = mode;
            this.processed = processed;
        }
    }

    private static class QueuedContribution {
        ProcessedContribution parent;
        MenuContribution contribution;

        public QueuedContribution(ProcessedContribution parent, MenuContribution contribution) {
            this.parent = parent;
            this.contribution = contribution;
        }
    }

    private static abstract class ProcessedContribution {
        List<ProcessedContribution> before = new LinkedList<ProcessedContribution>();
        List<ProcessedContribution> after = new LinkedList<ProcessedContribution>();

        private ProcessedContribution() {
        }

        abstract void process();

        abstract String getName();

        abstract boolean shouldCreate();

        abstract void finish();
    }
}

