/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.data.model;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.table.AbstractTableModel;
import org.exbin.framework.data.model.CatalogRevsTableItem;
import org.exbin.xbup.core.catalog.XBCatalog;
import org.exbin.xbup.core.catalog.base.XBCItem;
import org.exbin.xbup.core.catalog.base.XBCRev;
import org.exbin.xbup.core.catalog.base.XBCSpec;
import org.exbin.xbup.core.catalog.base.service.XBCRevService;
import org.exbin.xbup.core.catalog.base.service.XBCXDescService;
import org.exbin.xbup.core.catalog.base.service.XBCXNameService;

@ParametersAreNonnullByDefault
public class CatalogRevsTableModel
extends AbstractTableModel {
    private XBCatalog catalog;
    private XBCSpec spec;
    private final String[] columnNames = new String[]{"XBIndex", "Name", "Description", "XBLimit"};
    private final Class[] classes = new Class[]{Long.class, String.class, String.class, Long.class};
    private final List<CatalogRevsTableItem> revs = new ArrayList<CatalogRevsTableItem>();

    @Override
    public int getRowCount() {
        return this.revs.size();
    }

    @Override
    public int getColumnCount() {
        return this.classes.length;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.revs.get(rowIndex).getXbIndex();
            }
            case 1: {
                return this.revs.get(rowIndex).getName();
            }
            case 2: {
                return this.revs.get(rowIndex).getDescription();
            }
            case 3: {
                return this.revs.get(rowIndex).getLimit();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.classes[columnIndex];
    }

    public XBCSpec getSpec() {
        return this.spec;
    }

    public void setSpec(XBCSpec spec) {
        this.spec = spec;
        this.reloadItems();
    }

    private void reloadItems() {
        this.revs.clear();
        if (this.spec != null && this.catalog != null) {
            XBCRevService revService = (XBCRevService)this.catalog.getCatalogService(XBCRevService.class);
            XBCXNameService nameService = (XBCXNameService)this.catalog.getCatalogService(XBCXNameService.class);
            XBCXDescService descService = (XBCXDescService)this.catalog.getCatalogService(XBCXDescService.class);
            List revsList = revService.getRevs(this.spec);
            for (XBCRev rev : revsList) {
                CatalogRevsTableItem item = new CatalogRevsTableItem();
                item.setRev(rev);
                item.setXbIndex(rev.getXBIndex());
                item.setLimit(rev.getXBLimit());
                item.setName(nameService.getDefaultText((XBCItem)rev));
                item.setDescription(descService.getDefaultText((XBCItem)rev));
                this.revs.add(item);
            }
        }
        this.fireTableDataChanged();
    }

    public void setCatalog(XBCatalog catalog) {
        this.catalog = catalog;
        this.reloadItems();
    }

    public CatalogRevsTableItem getRowItem(int index) {
        return this.revs.get(index);
    }

    public List<CatalogRevsTableItem> getRevs() {
        return this.revs;
    }

    @Nullable
    public Long getRevisionForIndex(Long xbIndex) {
        long limitSum = 0L;
        for (int revision = 0; revision < this.revs.size(); ++revision) {
            CatalogRevsTableItem revItem = this.revs.get(revision);
            if (xbIndex < limitSum + revItem.getLimit()) {
                return revision;
            }
            limitSum += revItem.getLimit().longValue();
        }
        return null;
    }
}

