/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.xbup.service;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.exbin.framework.action.api.ActionModuleApi;
import org.exbin.framework.action.api.MenuManagement;
import org.exbin.framework.action.api.PositionMode;
import org.exbin.framework.api.Preferences;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.api.XBApplicationModule;
import org.exbin.framework.api.XBModuleRepositoryUtils;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.xbup.service.gui.ConnectionPanel;
import org.exbin.framework.xbup.service.gui.ServiceManagerPanel;
import org.exbin.xbup.plugin.XBModuleHandler;

@ParametersAreNonnullByDefault
public class XbupServiceModule
implements XBApplicationModule {
    public static final String MODULE_ID = XBModuleRepositoryUtils.getModuleIdByApi(XbupServiceModule.class);
    private XBApplication application;
    private ServiceManagerPanel servicePanel;
    private Preferences preferences;

    public void init(XBModuleHandler moduleHandler) {
        this.application = (XBApplication)moduleHandler;
    }

    public void unregisterModule(String moduleId) {
    }

    public void openConnectionDialog(Component parentComponent) {
        FrameModuleApi frameModule = (FrameModuleApi)this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
        ConnectionPanel panel = new ConnectionPanel();
        panel.setApplication(this.application);
        panel.loadConnectionList(this.preferences);
        WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)panel);
        WindowUtils.assignGlobalKeyListener((Component)dialog.getWindow(), (JButton)panel.getCloseButton());
        dialog.showCentered(parentComponent);
        dialog.dispose();
        panel.saveConnectionList(this.preferences);
        this.getServicePanel().setService(panel.getService());
    }

    @Nonnull
    public ServiceManagerPanel getServicePanel() {
        if (this.servicePanel == null) {
            this.servicePanel = new ServiceManagerPanel();
            this.servicePanel.setApplication(this.application);
            this.servicePanel.setMenuManagement(this.getDefaultMenuManagement());
        }
        return this.servicePanel;
    }

    @Nonnull
    public MenuManagement getDefaultMenuManagement() {
        return new MenuManagement(){

            public void extendMenu(JMenu menu, Integer pluginId, String menuId, PositionMode positionMode) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void addMenuItem(Component menuItem, Integer pluginId, String menuId, PositionMode mode) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void insertMenu(JMenu menu, Integer pluginId, PositionMode positionMode) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void extendToolBar(JToolBar toolBar) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void insertMainPopupMenu(JPopupMenu popupMenu, int position) {
                ActionModuleApi actionModule = (ActionModuleApi)XbupServiceModule.this.application.getModuleRepository().getModuleByInterface(ActionModuleApi.class);
                actionModule.fillPopupMenu(popupMenu, position);
            }
        };
    }

    @Nullable
    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }
}

