/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.stub;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.ImageIcon;
import org.exbin.xbup.client.XBCatalogServiceClient;
import org.exbin.xbup.client.catalog.remote.XBRNode;
import org.exbin.xbup.client.catalog.remote.XBRXFile;
import org.exbin.xbup.client.stub.XBPBaseStub;
import org.exbin.xbup.client.stub.XBPItemStub;
import org.exbin.xbup.client.stub.XBPStubUtils;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.catalog.base.XBCXFile;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.remote.XBCallHandler;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.type.XBData;
import org.exbin.xbup.core.util.StreamUtils;

@ParametersAreNonnullByDefault
public class XBPXFileStub
extends XBPBaseStub<XBCXFile> {
    public static long[] OWNER_FILE_PROCEDURE = new long[]{0L, 2L, 12L, 0L, 0L};
    public static long[] FILENAME_FILE_PROCEDURE = new long[]{0L, 2L, 12L, 1L, 0L};
    public static long[] DATA_FILE_PROCEDURE = new long[]{0L, 2L, 12L, 2L, 0L};
    public static long[] NODEFILES_FILE_PROCEDURE = new long[]{0L, 2L, 12L, 3L, 0L};
    private final XBCatalogServiceClient client;

    public XBPXFileStub(XBCatalogServiceClient client) {
        super(client, XBRXFile::new, null);
        this.client = client;
    }

    public XBRNode getNode(long fileId) {
        Long index = XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(OWNER_FILE_PROCEDURE), fileId);
        return index == null ? null : new XBRNode(this.client, index);
    }

    public String getFilename(long fileId) {
        return XBPStubUtils.longToStringMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(FILENAME_FILE_PROCEDURE), fileId);
    }

    public ImageIcon getFileAsImageIcon(XBCXFile iconFile) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(DATA_FILE_PROCEDURE));
            serialInput.putAttribute(iconFile.getId());
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            serialOutput.begin();
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            StreamUtils.copyInputStreamToOutputStream((InputStream)serialOutput.pullData(), (OutputStream)data);
            serialOutput.end();
            procedureCall.execute();
            return new ImageIcon(data.toByteArray());
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPItemStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public InputStream getFile(XBCXFile file) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(DATA_FILE_PROCEDURE));
            serialInput.putAttribute(file.getId());
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            XBData data = new XBData();
            serialOutput.process((XBSerializable)data);
            procedureCall.execute();
            return data.getDataInputStream();
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPItemStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public List<XBCXFile> findFilesForNode(XBCNode node) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(NODEFILES_FILE_PROCEDURE));
            serialInput.putAttribute(node.getId());
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            if (!serialOutput.pullIfEmptyBlock()) {
                serialOutput.begin();
                serialOutput.matchType();
                long count = serialOutput.pullLongAttribute();
                ArrayList<XBCXFile> result = new ArrayList<XBCXFile>();
                int i = 0;
                while ((long)i < count) {
                    result.add(new XBRXFile(this.client, serialOutput.pullLongAttribute()));
                    ++i;
                }
                serialOutput.end();
                procedureCall.execute();
                return result;
            }
            procedureCall.execute();
            return null;
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPItemStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

