/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.stub;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.remote.XBCallHandler;
import org.exbin.xbup.core.remote.XBServiceClient;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.type.XBNatural;
import org.exbin.xbup.core.type.XBString;

public class XBPServiceStub {
    public static long[] LOGIN_SERVICE_PROCEDURE = new long[]{0L, 2L, 0L, 0L, 0L};
    public static long[] STOP_SERVICE_PROCEDURE = new long[]{0L, 2L, 0L, 1L, 0L};
    public static long[] RESTART_SERVICE_PROCEDURE = new long[]{0L, 2L, 0L, 2L, 0L};
    public static long[] PING_SERVICE_PROCEDURE = new long[]{0L, 2L, 0L, 3L, 0L};
    public static long[] VERSION_INFO_PROCEDURE = new long[]{0L, 2L, 1L, 0L, 0L};
    private final XBServiceClient client;

    public XBPServiceStub(XBServiceClient client) {
        this.client = client;
    }

    public int login(String user, char[] password) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            if (procedureCall == null) {
                return -1;
            }
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(LOGIN_SERVICE_PROCEDURE));
            XBString userName = new XBString(user);
            serialInput.consist((XBSerializable)userName);
            XBString userPass = new XBString(new String(password));
            serialInput.consist((XBSerializable)userPass);
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            serialOutput.begin();
            serialOutput.pullType();
            int loginResult = serialOutput.pullIntAttribute();
            serialOutput.end();
            procedureCall.execute();
            return loginResult;
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPServiceStub.class.getName()).log(Level.SEVERE, null, ex);
            return 0;
        }
    }

    public String getVersion() {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(VERSION_INFO_PROCEDURE));
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            XBString version = new XBString();
            serialOutput.process((XBSerializable)version);
            procedureCall.execute();
            return version.getValue();
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPServiceStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void stop() {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(STOP_SERVICE_PROCEDURE));
            serialInput.end();
            procedureCall.execute();
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPServiceStub.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean ping() {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(PING_SERVICE_PROCEDURE));
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            XBNatural value = new XBNatural();
            serialOutput.process((XBSerializable)value);
            procedureCall.execute();
            return true;
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPServiceStub.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }
}

