/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.stub;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.client.XBCatalogServiceClient;
import org.exbin.xbup.client.catalog.remote.XBRNode;
import org.exbin.xbup.client.stub.XBPBaseProcedureType;
import org.exbin.xbup.client.stub.XBPBaseStub;
import org.exbin.xbup.client.stub.XBPItemStub;
import org.exbin.xbup.client.stub.XBPStubUtils;
import org.exbin.xbup.core.block.XBBlockType;
import org.exbin.xbup.core.block.declaration.XBDeclBlockType;
import org.exbin.xbup.core.catalog.base.XBCNode;
import org.exbin.xbup.core.parser.XBProcessingException;
import org.exbin.xbup.core.remote.XBCallHandler;
import org.exbin.xbup.core.serial.XBSerializable;
import org.exbin.xbup.core.serial.param.XBPListenerSerialHandler;
import org.exbin.xbup.core.serial.param.XBPProviderSerialHandler;
import org.exbin.xbup.core.ubnumber.type.UBNat32;

@ParametersAreNonnullByDefault
public class XBPNodeStub
extends XBPBaseStub<XBCNode> {
    public static long[] ROOT_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 0L, 0L};
    public static long[] SUBNODE_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 1L, 0L};
    public static long[] SUBNODES_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 2L, 0L};
    public static long[] SUBNODESCOUNT_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 3L, 0L};
    public static long[] FINDOWNER_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 12L, 0L};
    public static long[] PATHNODE_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 13L, 0L};
    public static long[] FINDNODE_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 14L, 0L};
    public static long[] MAXSUBNODE_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 15L, 0L};
    public static long[] NODESCOUNT_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 26L, 0L};
    public static long[] SUBNODESEQ_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 27L, 0L};
    public static long[] SUBNODESEQCNT_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 28L, 0L};
    public static long[] MAINROOT_NODE_PROCEDURE = new long[]{0L, 2L, 4L, 29L, 0L};
    private final XBCatalogServiceClient client;

    public XBPNodeStub(XBCatalogServiceClient client) {
        super(client, XBRNode::new, new XBPBaseProcedureType(null, null, null, null, (XBBlockType)new XBDeclBlockType(NODESCOUNT_NODE_PROCEDURE)));
        this.client = client;
    }

    public XBRNode getRootNode(long rootId) {
        Long index = XBPStubUtils.longToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(ROOT_NODE_PROCEDURE), rootId);
        return index == null ? null : new XBRNode(this.client, index);
    }

    @Nonnull
    public Optional<XBCNode> getMainRootNode() {
        Long index = XBPStubUtils.voidToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(MAINROOT_NODE_PROCEDURE));
        return index == null ? Optional.empty() : Optional.of(new XBRNode(this.client, index));
    }

    public List<XBCNode> getSubNodes(XBCNode node) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(SUBNODES_NODE_PROCEDURE));
            serialInput.putAttribute(node.getId());
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            if (!serialOutput.pullIfEmptyBlock()) {
                serialOutput.begin();
                serialOutput.matchType();
                long count = serialOutput.pullLongAttribute();
                ArrayList<XBCNode> result = new ArrayList<XBCNode>();
                int i = 0;
                while ((long)i < count) {
                    result.add(new XBRNode(this.client, serialOutput.pullLongAttribute()));
                    ++i;
                }
                serialOutput.end();
                procedureCall.execute();
                return result;
            }
            procedureCall.execute();
            return null;
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPItemStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBRNode getSubNode(XBCNode node, long index) {
        return this.findSubNodeByXB(node, index);
    }

    public long getSubNodesCount(XBCNode node) {
        return XBPStubUtils.voidToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(SUBNODESCOUNT_NODE_PROCEDURE));
    }

    public XBRNode findNodeByXBPath(Long[] catalogPath) {
        Long catalogPathNode;
        XBRNode node = (XBRNode)this.getMainRootNode().get();
        Long[] longArray = catalogPath;
        int n = longArray.length;
        for (int i = 0; i < n && (node = this.getSubNode(node, catalogPathNode = longArray[i])) != null; ++i) {
        }
        return node;
    }

    public XBRNode findParentByXBPath(Long[] xbCatalogPath) {
        if (xbCatalogPath.length == 0) {
            return null;
        }
        XBRNode node = (XBRNode)this.getMainRootNode().get();
        for (int i = 0; i < xbCatalogPath.length - 1 && (node = this.getSubNode(node, xbCatalogPath[i])) != null; ++i) {
        }
        return node;
    }

    public Long[] getNodeXBPath(XBCNode node) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(PATHNODE_NODE_PROCEDURE));
            serialInput.putAttribute(node.getId());
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            if (!serialOutput.pullIfEmptyBlock()) {
                serialOutput.begin();
                serialOutput.matchType();
                long pathLength = serialOutput.pullLongAttribute();
                Long[] result = new Long[(int)pathLength];
                int i = 0;
                while ((long)i < pathLength) {
                    result[i] = serialOutput.pullLongAttribute();
                    ++i;
                }
                serialOutput.end();
                procedureCall.execute();
                return result;
            }
            procedureCall.execute();
            return null;
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPItemStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBRNode findOwnerByXBPath(Long[] catalogPath) {
        try {
            XBCallHandler procedureCall = this.client.procedureCall();
            XBPListenerSerialHandler serialInput = new XBPListenerSerialHandler(procedureCall.getParametersInput());
            serialInput.begin();
            serialInput.putType((XBBlockType)new XBDeclBlockType(FINDOWNER_NODE_PROCEDURE));
            serialInput.putAttribute(catalogPath.length);
            for (Long catalogPathNode : catalogPath) {
                serialInput.putAttribute(catalogPathNode.longValue());
            }
            serialInput.end();
            XBPProviderSerialHandler serialOutput = new XBPProviderSerialHandler(procedureCall.getResultOutput());
            UBNat32 index = new UBNat32();
            serialOutput.process((XBSerializable)index);
            procedureCall.execute();
            return new XBRNode(this.client, index.getLong());
        }
        catch (IOException | XBProcessingException ex) {
            Logger.getLogger(XBPNodeStub.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public XBRNode findSubNodeByXB(XBCNode node, long xbIndex) {
        Long index = XBPStubUtils.twoLongsToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(SUBNODE_NODE_PROCEDURE), node.getId(), xbIndex);
        return index == null ? null : new XBRNode(this.client, index);
    }

    public Long findMaxSubNodeXB(XBCNode node) {
        return XBPStubUtils.voidToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(MAXSUBNODE_NODE_PROCEDURE));
    }

    public XBRNode getSubNodeSeq(XBCNode node, long seq) {
        Long index = XBPStubUtils.twoLongsToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(SUBNODESEQ_NODE_PROCEDURE), node.getId(), seq);
        return index == null ? null : new XBRNode(this.client, index);
    }

    public long getSubNodesSeq(XBCNode node) {
        return XBPStubUtils.voidToLongMethod(this.client.procedureCall(), (XBBlockType)new XBDeclBlockType(SUBNODESEQCNT_NODE_PROCEDURE));
    }
}

