/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.xbup.client.catalog.remote.manager;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.xbup.client.XBCatalogServiceClient;
import org.exbin.xbup.client.catalog.XBRCatalog;
import org.exbin.xbup.client.stub.XBPManagerStub;
import org.exbin.xbup.core.catalog.base.XBCBase;
import org.exbin.xbup.core.catalog.base.manager.XBCManager;

@ParametersAreNonnullByDefault
public abstract class XBRDefaultManager<T extends XBCBase>
implements XBCManager<T> {
    protected XBRCatalog catalog;
    protected XBCatalogServiceClient client;
    private XBPManagerStub<T> managerStub = null;

    public XBRDefaultManager(XBRCatalog catalog) {
        this.catalog = catalog;
        this.client = catalog.getCatalogServiceClient();
    }

    public XBPManagerStub<T> getManagerStub() {
        return this.managerStub;
    }

    public void setManagerStub(XBPManagerStub<T> managerStub) {
        this.managerStub = managerStub;
    }

    @Nonnull
    public T createItem() {
        if (this.managerStub != null) {
            return this.managerStub.createItem();
        }
        throw new IllegalStateException("Operation not supported");
    }

    public void removeItem(T item) {
        if (this.managerStub != null) {
            this.managerStub.removeItem(item);
        }
        throw new IllegalStateException("Operation not supported");
    }

    @Nonnull
    public List<T> getAllItems() {
        if (this.managerStub != null) {
            return this.managerStub.getAllItems();
        }
        throw new IllegalStateException("Operation not supported");
    }

    @Nonnull
    public Optional<T> getItem(long itemId) {
        if (this.managerStub != null) {
            return this.managerStub.getItem(itemId);
        }
        throw new IllegalStateException("Operation not supported");
    }

    public long getItemsCount() {
        if (this.managerStub != null) {
            return this.managerStub.getItemsCount();
        }
        throw new IllegalStateException("Operation not supported");
    }

    public void persistItem(T item) {
        if (this.managerStub != null) {
            this.managerStub.persistItem(item);
        }
        throw new IllegalStateException("Operation not supported");
    }

    public boolean initCatalog() {
        return true;
    }
}

