/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.options.impl;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.framework.editor.text.options.TextFontOptions;
import org.exbin.framework.editor.text.preferences.TextFontPreferences;
import org.exbin.framework.options.api.OptionsData;

@ParametersAreNonnullByDefault
public class TextFontOptionsImpl
implements TextFontOptions,
OptionsData {
    private boolean useDefaultFont = true;
    @Nullable
    private Map<TextAttribute, ?> fontAttributes = null;

    @Override
    public boolean isUseDefaultFont() {
        return this.useDefaultFont;
    }

    @Override
    public void setUseDefaultFont(boolean useDefaultFont) {
        this.useDefaultFont = useDefaultFont;
    }

    @Override
    @Nullable
    public Map<TextAttribute, ?> getFontAttributes() {
        return this.fontAttributes;
    }

    @Override
    public void setFontAttributes(@Nullable Map<TextAttribute, ?> fontAttributes) {
        this.fontAttributes = fontAttributes;
    }

    public void loadFromPreferences(TextFontPreferences preferences) {
        this.useDefaultFont = preferences.isUseDefaultFont();
        this.fontAttributes = preferences.getFontAttributes();
    }

    public void saveToPreferences(TextFontPreferences preferences) {
        preferences.setUseDefaultFont(this.useDefaultFont);
        preferences.setFontAttributes(this.fontAttributes);
    }

    public void setOptions(TextFontOptionsImpl options) {
        this.useDefaultFont = options.useDefaultFont;
        this.fontAttributes = new HashMap();
        this.fontAttributes.putAll(options.fontAttributes);
    }

    @Override
    @Nonnull
    public Font getFont(Font initialFont) {
        Map<TextAttribute, ?> attribs = this.getFontAttributes();
        Font font = initialFont.deriveFont(attribs);
        return font;
    }
}

