/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.options.gui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.exbin.framework.editor.text.options.impl.TextColorOptionsImpl;
import org.exbin.framework.editor.text.service.TextColorService;
import org.exbin.framework.options.api.OptionsComponent;
import org.exbin.framework.options.api.OptionsModifiedListener;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class TextColorPanel
extends JPanel
implements OptionsComponent<TextColorOptionsImpl> {
    private OptionsModifiedListener optionsModifiedListener;
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(TextColorPanel.class);
    private static final String RESOURCE_COLOR_CHOOSER_TITLE = "JColorChooser.title";
    private TextColorService textColorService;
    private JColorChooser colorChooser;
    private JPanel controlButtonsPanel;
    private JButton fillCurrentButton;
    private JButton fillDefaultButton;
    private JLabel foundBackgroundColorLabel;
    private JPanel foundBackgroundColorPanel;
    private JLabel foundTextLabel;
    private JLabel normalTextLabel;
    private JButton selectFoundBackgroundColorButton;
    private JButton selectSelectionBackgroundColorButton;
    private JButton selectSelectionTextColorButton;
    private JButton selectTextBackgroundColorButton;
    private JButton selectTextColorButton;
    private JLabel selectedTextLabel;
    private JLabel selectionBackgroundColorLabel;
    private JPanel selectionBackgroundColorPanel;
    private JLabel selectionTextColorLabel;
    private JPanel selectionTextColorPanel;
    private JLabel textBackgroundColorLabel;
    private JPanel textBackgroundColorPanel;
    private JLabel textColorLabel;
    private JPanel textColorPanel;
    private JPanel textColorsPreviewPanel;

    public TextColorPanel() {
        this.initComponents();
    }

    public void setTextColorService(TextColorService textColorService) {
        this.textColorService = textColorService;
        this.fillCurrentButton.setEnabled(true);
        this.fillDefaultButton.setEnabled(true);
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void loadFromOptions(TextColorOptionsImpl options) {
        Integer rgb;
        this.setColorsFromArray(this.textColorService.getDefaultTextColors());
        try {
            rgb = options.getTextColor();
            if (rgb != null) {
                this.setTextColor(new Color(rgb));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            rgb = options.getTextBackgroundColor();
            if (rgb != null) {
                this.setTextBackgroundColor(new Color(rgb));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            rgb = options.getSelectionTextColor();
            if (rgb != null) {
                this.setSelectionTextColor(new Color(rgb));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            rgb = options.getSelectionBackgroundColor();
            if (rgb != null) {
                this.setSelectionBackgroundColor(new Color(rgb));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            rgb = options.getFoundBackgroundColor();
            if (rgb != null) {
                this.setFoundBackgroundColor(new Color(rgb));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void saveToOptions(TextColorOptionsImpl options) {
        options.setTextColor(this.getTextColor().getRGB());
        options.setTextBackgroundColor(this.getTextBackgroundColor().getRGB());
        options.setSelectionTextColor(this.getSelectionTextColor().getRGB());
        options.setSelectionBackgroundColor(this.getSelectionBackgroundColor().getRGB());
        options.setFoundBackgroundColor(this.getFoundBackgroundColor().getRGB());
    }

    public Color getTextColor() {
        return this.textColorPanel.getBackground();
    }

    public Color getTextBackgroundColor() {
        return this.textBackgroundColorPanel.getBackground();
    }

    public Color getSelectionTextColor() {
        return this.selectionTextColorPanel.getBackground();
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColorPanel.getBackground();
    }

    public Color getFoundBackgroundColor() {
        return this.foundBackgroundColorPanel.getBackground();
    }

    public void setTextColor(Color color) {
        this.textColorPanel.setBackground(color);
        this.normalTextLabel.setForeground(color);
        this.foundTextLabel.setForeground(color);
    }

    public void setTextBackgroundColor(Color color) {
        this.textBackgroundColorPanel.setBackground(color);
        this.normalTextLabel.setBackground(color);
    }

    public void setSelectionTextColor(Color color) {
        this.selectionTextColorPanel.setBackground(color);
        this.selectedTextLabel.setForeground(color);
    }

    public void setSelectionBackgroundColor(Color color) {
        this.selectionBackgroundColorPanel.setBackground(color);
        this.selectedTextLabel.setBackground(color);
    }

    public void setFoundBackgroundColor(Color color) {
        this.foundBackgroundColorPanel.setBackground(color);
        this.foundTextLabel.setBackground(color);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.normalTextLabel.setEnabled(enabled);
        this.selectedTextLabel.setEnabled(enabled);
        this.foundTextLabel.setEnabled(enabled);
        this.selectTextBackgroundColorButton.setEnabled(enabled);
        this.selectSelectionTextColorButton.setEnabled(enabled);
        this.selectSelectionBackgroundColorButton.setEnabled(enabled);
        this.selectTextColorButton.setEnabled(enabled);
        this.selectFoundBackgroundColorButton.setEnabled(enabled);
        this.fillCurrentButton.setEnabled(enabled && this.textColorService != null);
        this.fillDefaultButton.setEnabled(enabled && this.textColorService != null);
    }

    private void initComponents() {
        this.colorChooser = new JColorChooser();
        this.textColorPanel = new JPanel();
        this.selectTextColorButton = new JButton();
        this.textBackgroundColorPanel = new JPanel();
        this.selectTextBackgroundColorButton = new JButton();
        this.selectionTextColorPanel = new JPanel();
        this.selectSelectionTextColorButton = new JButton();
        this.selectionBackgroundColorPanel = new JPanel();
        this.selectSelectionBackgroundColorButton = new JButton();
        this.foundBackgroundColorPanel = new JPanel();
        this.selectFoundBackgroundColorButton = new JButton();
        this.textColorLabel = new JLabel();
        this.textBackgroundColorLabel = new JLabel();
        this.selectionTextColorLabel = new JLabel();
        this.selectionBackgroundColorLabel = new JLabel();
        this.foundBackgroundColorLabel = new JLabel();
        this.textColorsPreviewPanel = new JPanel();
        this.normalTextLabel = new JLabel();
        this.selectedTextLabel = new JLabel();
        this.foundTextLabel = new JLabel();
        this.controlButtonsPanel = new JPanel();
        this.fillCurrentButton = new JButton();
        this.fillDefaultButton = new JButton();
        this.colorChooser.setName("colorChooser");
        this.setName("Form");
        this.textColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.textColorPanel.setName("textColorPanel");
        GroupLayout textColorPanelLayout = new GroupLayout(this.textColorPanel);
        this.textColorPanel.setLayout(textColorPanelLayout);
        textColorPanelLayout.setHorizontalGroup(textColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        textColorPanelLayout.setVerticalGroup(textColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        this.selectTextColorButton.setText(this.resourceBundle.getString("selectButton.text"));
        this.selectTextColorButton.setName("selectTextColorButton");
        this.selectTextColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextColorPanel.this.selectTextColorButtonActionPerformed(evt);
            }
        });
        this.textBackgroundColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.textBackgroundColorPanel.setName("textBackgroundColorPanel");
        GroupLayout textBackgroundColorPanelLayout = new GroupLayout(this.textBackgroundColorPanel);
        this.textBackgroundColorPanel.setLayout(textBackgroundColorPanelLayout);
        textBackgroundColorPanelLayout.setHorizontalGroup(textBackgroundColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        textBackgroundColorPanelLayout.setVerticalGroup(textBackgroundColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        this.selectTextBackgroundColorButton.setText(this.resourceBundle.getString("selectButton.text"));
        this.selectTextBackgroundColorButton.setName("selectTextBackgroundColorButton");
        this.selectTextBackgroundColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextColorPanel.this.selectTextBackgroundColorButtonActionPerformed(evt);
            }
        });
        this.selectionTextColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.selectionTextColorPanel.setName("selectionTextColorPanel");
        GroupLayout selectionTextColorPanelLayout = new GroupLayout(this.selectionTextColorPanel);
        this.selectionTextColorPanel.setLayout(selectionTextColorPanelLayout);
        selectionTextColorPanelLayout.setHorizontalGroup(selectionTextColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        selectionTextColorPanelLayout.setVerticalGroup(selectionTextColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        this.selectSelectionTextColorButton.setText(this.resourceBundle.getString("selectButton.text"));
        this.selectSelectionTextColorButton.setName("selectSelectionTextColorButton");
        this.selectSelectionTextColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextColorPanel.this.selectSelectionTextColorButtonActionPerformed(evt);
            }
        });
        this.selectionBackgroundColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.selectionBackgroundColorPanel.setName("selectionBackgroundColorPanel");
        GroupLayout selectionBackgroundColorPanelLayout = new GroupLayout(this.selectionBackgroundColorPanel);
        this.selectionBackgroundColorPanel.setLayout(selectionBackgroundColorPanelLayout);
        selectionBackgroundColorPanelLayout.setHorizontalGroup(selectionBackgroundColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        selectionBackgroundColorPanelLayout.setVerticalGroup(selectionBackgroundColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        this.selectSelectionBackgroundColorButton.setText(this.resourceBundle.getString("selectButton.text"));
        this.selectSelectionBackgroundColorButton.setName("selectSelectionBackgroundColorButton");
        this.selectSelectionBackgroundColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextColorPanel.this.selectSelectionBackgroundColorButtonActionPerformed(evt);
            }
        });
        this.foundBackgroundColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.foundBackgroundColorPanel.setName("foundBackgroundColorPanel");
        GroupLayout foundBackgroundColorPanelLayout = new GroupLayout(this.foundBackgroundColorPanel);
        this.foundBackgroundColorPanel.setLayout(foundBackgroundColorPanelLayout);
        foundBackgroundColorPanelLayout.setHorizontalGroup(foundBackgroundColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        foundBackgroundColorPanelLayout.setVerticalGroup(foundBackgroundColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        this.selectFoundBackgroundColorButton.setText(this.resourceBundle.getString("selectButton.text"));
        this.selectFoundBackgroundColorButton.setName("selectFoundBackgroundColorButton");
        this.selectFoundBackgroundColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextColorPanel.this.selectFoundBackgroundColorButtonActionPerformed(evt);
            }
        });
        this.textColorLabel.setText(this.resourceBundle.getString("textColorLabel.text"));
        this.textColorLabel.setName("textColorLabel");
        this.textBackgroundColorLabel.setText(this.resourceBundle.getString("textBackgroundColorLabel.text"));
        this.textBackgroundColorLabel.setName("textBackgroundColorLabel");
        this.selectionTextColorLabel.setText(this.resourceBundle.getString("selectionTextColorLabel.text"));
        this.selectionTextColorLabel.setName("selectionTextColorLabel");
        this.selectionBackgroundColorLabel.setText(this.resourceBundle.getString("selectionBackgroundColorLabel.text"));
        this.selectionBackgroundColorLabel.setName("selectionBackgroundColorLabel");
        this.foundBackgroundColorLabel.setText(this.resourceBundle.getString("foundBackgroundColorLabel.text"));
        this.foundBackgroundColorLabel.setName("foundBackgroundColorLabel");
        this.textColorsPreviewPanel.setName("textColorsPreviewPanel");
        this.textColorsPreviewPanel.setLayout(new GridLayout(1, 3));
        this.normalTextLabel.setBackground(new Color(255, 255, 255));
        this.normalTextLabel.setHorizontalAlignment(0);
        this.normalTextLabel.setText(this.resourceBundle.getString("normalTextLabel.text"));
        this.normalTextLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.normalTextLabel.setName("normalTextLabel");
        this.normalTextLabel.setOpaque(true);
        this.textColorsPreviewPanel.add(this.normalTextLabel);
        this.selectedTextLabel.setBackground(new Color(255, 255, 255));
        this.selectedTextLabel.setHorizontalAlignment(0);
        this.selectedTextLabel.setText(this.resourceBundle.getString("selectedTextLabel.text"));
        this.selectedTextLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.selectedTextLabel.setName("selectedTextLabel");
        this.selectedTextLabel.setOpaque(true);
        this.textColorsPreviewPanel.add(this.selectedTextLabel);
        this.foundTextLabel.setBackground(new Color(255, 255, 255));
        this.foundTextLabel.setHorizontalAlignment(0);
        this.foundTextLabel.setText(this.resourceBundle.getString("foundTextLabel.text"));
        this.foundTextLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.foundTextLabel.setName("foundTextLabel");
        this.foundTextLabel.setOpaque(true);
        this.textColorsPreviewPanel.add(this.foundTextLabel);
        this.controlButtonsPanel.setName("controlButtonsPanel");
        this.fillCurrentButton.setText(this.resourceBundle.getString("fillCurrentButton.text"));
        this.fillCurrentButton.setEnabled(false);
        this.fillCurrentButton.setName("fillCurrentButton");
        this.fillCurrentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextColorPanel.this.fillCurrentButtonActionPerformed(evt);
            }
        });
        this.fillDefaultButton.setText(this.resourceBundle.getString("fillDefaultButton.text"));
        this.fillDefaultButton.setEnabled(false);
        this.fillDefaultButton.setName("fillDefaultButton");
        this.fillDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextColorPanel.this.fillDefaultButtonActionPerformed(evt);
            }
        });
        GroupLayout controlButtonsPanelLayout = new GroupLayout(this.controlButtonsPanel);
        this.controlButtonsPanel.setLayout(controlButtonsPanelLayout);
        controlButtonsPanelLayout.setHorizontalGroup(controlButtonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlButtonsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fillDefaultButton).addGap(12, 12, 12).addComponent(this.fillCurrentButton).addContainerGap(-1, Short.MAX_VALUE)));
        controlButtonsPanelLayout.setVerticalGroup(controlButtonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlButtonsPanelLayout.createSequentialGroup().addContainerGap().addGroup(controlButtonsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fillCurrentButton).addComponent(this.fillDefaultButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textColorsPreviewPanel, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textBackgroundColorPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.selectionBackgroundColorLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.selectionBackgroundColorPanel, -1, -1, Short.MAX_VALUE).addComponent(this.selectionTextColorPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.foundBackgroundColorPanel, -1, -1, Short.MAX_VALUE).addComponent(this.textColorPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectFoundBackgroundColorButton).addComponent(this.selectSelectionBackgroundColorButton).addComponent(this.selectSelectionTextColorButton).addComponent(this.selectTextBackgroundColorButton).addComponent(this.selectTextColorButton))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.foundBackgroundColorLabel).addComponent(this.selectionTextColorLabel).addComponent(this.textBackgroundColorLabel).addComponent(this.textColorLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addComponent(this.controlButtonsPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.textColorsPreviewPanel, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textColorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.selectTextColorButton).addComponent(this.textColorPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textBackgroundColorLabel).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textBackgroundColorPanel, -2, -1, -2).addComponent(this.selectTextBackgroundColorButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectionTextColorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectSelectionTextColorButton).addComponent(this.selectionTextColorPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.selectionBackgroundColorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectionBackgroundColorPanel, -2, -1, -2)).addComponent(this.selectSelectionBackgroundColorButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.foundBackgroundColorLabel).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectFoundBackgroundColorButton).addComponent(this.foundBackgroundColorPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.controlButtonsPanel, -2, -1, -2)));
    }

    private void selectTextColorButtonActionPerformed(ActionEvent evt) {
        this.colorChooser.setColor(this.textColorPanel.getBackground());
        JDialog dialog = JColorChooser.createDialog(this, this.resourceBundle.getString(RESOURCE_COLOR_CHOOSER_TITLE), true, this.colorChooser, e -> this.setTextColor(this.colorChooser.getColor()), null);
        dialog.setVisible(true);
    }

    private void selectTextBackgroundColorButtonActionPerformed(ActionEvent evt) {
        this.colorChooser.setColor(this.textBackgroundColorPanel.getBackground());
        JDialog dialog = JColorChooser.createDialog(this, this.resourceBundle.getString(RESOURCE_COLOR_CHOOSER_TITLE), true, this.colorChooser, e -> this.setTextBackgroundColor(this.colorChooser.getColor()), null);
        dialog.setVisible(true);
    }

    private void selectSelectionTextColorButtonActionPerformed(ActionEvent evt) {
        this.colorChooser.setColor(this.selectionTextColorPanel.getBackground());
        JDialog dialog = JColorChooser.createDialog(this, this.resourceBundle.getString(RESOURCE_COLOR_CHOOSER_TITLE), true, this.colorChooser, e -> this.setSelectionTextColor(this.colorChooser.getColor()), null);
        dialog.setVisible(true);
    }

    private void selectSelectionBackgroundColorButtonActionPerformed(ActionEvent evt) {
        this.colorChooser.setColor(this.selectionBackgroundColorPanel.getBackground());
        JDialog dialog = JColorChooser.createDialog(this, this.resourceBundle.getString(RESOURCE_COLOR_CHOOSER_TITLE), true, this.colorChooser, e -> this.setSelectionBackgroundColor(this.colorChooser.getColor()), null);
        dialog.setVisible(true);
    }

    private void selectFoundBackgroundColorButtonActionPerformed(ActionEvent evt) {
        this.colorChooser.setColor(this.foundBackgroundColorPanel.getBackground());
        JDialog dialog = JColorChooser.createDialog(this, this.resourceBundle.getString(RESOURCE_COLOR_CHOOSER_TITLE), true, this.colorChooser, e -> this.setFoundBackgroundColor(this.colorChooser.getColor()), null);
        dialog.setVisible(true);
    }

    private void fillCurrentButtonActionPerformed(ActionEvent evt) {
        Color[] currentColors = this.textColorService.getCurrentTextColors();
        this.setColorsFromArray(currentColors);
        this.setModified(true);
    }

    private void fillDefaultButtonActionPerformed(ActionEvent evt) {
        Color[] defaultColors = this.textColorService.getDefaultTextColors();
        this.setColorsFromArray(defaultColors);
        this.setModified(true);
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new TextColorPanel());
    }

    public void setColorsFromArray(Color[] colors) {
        this.setTextColor(colors[0]);
        this.setTextBackgroundColor(colors[1]);
        this.setSelectionTextColor(colors[2]);
        this.setSelectionBackgroundColor(colors[3]);
        this.setFoundBackgroundColor(colors[4]);
    }

    @Nonnull
    public Color[] getArrayFromColors() {
        Color[] colors = new Color[]{this.getTextColor(), this.getTextBackgroundColor(), this.getSelectionTextColor(), this.getSelectionBackgroundColor(), this.getFoundBackgroundColor()};
        return colors;
    }

    private void setModified(boolean b) {
        if (this.optionsModifiedListener != null) {
            this.optionsModifiedListener.wasModified();
        }
    }

    public void setOptionsModifiedListener(OptionsModifiedListener listener) {
        this.optionsModifiedListener = listener;
    }
}

