/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class FindTextPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(FindTextPanel.class);
    private JPanel findPanel;
    private JCheckBox matchCaseCheckBox;
    private JCheckBox performReplaceCheckBox;
    private JCheckBox replaceAllMatchesCheckBox;
    private JPanel replacePanel;
    private JCheckBox searchFromCursorCheckBox;
    private JLabel textToFindLabel;
    private JTextField textToFindTextField;
    private JLabel textToReplaceLabel;
    private JTextField textToReplaceTextField;

    public FindTextPanel() {
        this.initComponents();
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private void initComponents() {
        this.findPanel = new JPanel();
        this.textToFindLabel = new JLabel();
        this.textToFindTextField = new JTextField();
        this.searchFromCursorCheckBox = new JCheckBox();
        this.matchCaseCheckBox = new JCheckBox();
        this.replacePanel = new JPanel();
        this.performReplaceCheckBox = new JCheckBox();
        this.textToReplaceLabel = new JLabel();
        this.textToReplaceTextField = new JTextField();
        this.replaceAllMatchesCheckBox = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.findPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("findPanel.border.title")));
        this.textToFindLabel.setText(this.resourceBundle.getString("textToFindLabel.text"));
        this.searchFromCursorCheckBox.setSelected(true);
        this.searchFromCursorCheckBox.setText(this.resourceBundle.getString("searchFromCursorCheckBox.text"));
        this.matchCaseCheckBox.setText(this.resourceBundle.getString("matchCaseCheckBox.text"));
        this.matchCaseCheckBox.setEnabled(false);
        GroupLayout findPanelLayout = new GroupLayout(this.findPanel);
        this.findPanel.setLayout(findPanelLayout);
        findPanelLayout.setHorizontalGroup(findPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(findPanelLayout.createSequentialGroup().addContainerGap().addGroup(findPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.matchCaseCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.searchFromCursorCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.textToFindLabel).addComponent(this.textToFindTextField)).addContainerGap()));
        findPanelLayout.setVerticalGroup(findPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(findPanelLayout.createSequentialGroup().addComponent(this.textToFindLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textToFindTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchFromCursorCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.matchCaseCheckBox).addContainerGap(8, Short.MAX_VALUE)));
        this.add((Component)this.findPanel, "Center");
        this.replacePanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("replacePanel.border.title")));
        this.performReplaceCheckBox.setText(this.resourceBundle.getString("performReplaceCheckBox.text"));
        this.performReplaceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindTextPanel.this.performReplaceCheckBoxActionPerformed(evt);
            }
        });
        this.textToReplaceLabel.setText(this.resourceBundle.getString("textToReplaceLabel.text"));
        this.textToReplaceTextField.setEnabled(false);
        this.replaceAllMatchesCheckBox.setText(this.resourceBundle.getString("replaceAllMatchesCheckBox.text"));
        this.replaceAllMatchesCheckBox.setEnabled(false);
        GroupLayout replacePanelLayout = new GroupLayout(this.replacePanel);
        this.replacePanel.setLayout(replacePanelLayout);
        replacePanelLayout.setHorizontalGroup(replacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(replacePanelLayout.createSequentialGroup().addContainerGap().addGroup(replacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.performReplaceCheckBox, -1, 472, Short.MAX_VALUE).addComponent(this.textToReplaceLabel).addComponent(this.textToReplaceTextField, -1, 472, Short.MAX_VALUE).addComponent(this.replaceAllMatchesCheckBox, -1, 472, Short.MAX_VALUE)).addContainerGap()));
        replacePanelLayout.setVerticalGroup(replacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(replacePanelLayout.createSequentialGroup().addComponent(this.performReplaceCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textToReplaceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textToReplaceTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replaceAllMatchesCheckBox).addContainerGap(27, Short.MAX_VALUE)));
        this.add((Component)this.replacePanel, "South");
    }

    private void performReplaceCheckBoxActionPerformed(ActionEvent evt) {
        this.textToReplaceTextField.setEnabled(this.performReplaceCheckBox.isSelected());
        this.textToReplaceLabel.setEnabled(this.performReplaceCheckBox.isSelected());
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new FindTextPanel());
    }

    public boolean isSearchFromStart() {
        return !this.searchFromCursorCheckBox.isSelected();
    }

    public void setSelected() {
        this.textToFindTextField.requestFocusInWindow();
        this.textToFindTextField.selectAll();
    }

    @Nonnull
    public String getFindText() {
        return this.textToFindTextField.getText();
    }

    public void setFindText(String text) {
        this.textToFindTextField.setText(text);
    }

    public boolean isShallReplace() {
        return this.performReplaceCheckBox.isSelected();
    }

    public void setShallReplace(boolean shallReplace) {
        this.performReplaceCheckBox.setSelected(shallReplace);
        this.performReplaceCheckBoxActionPerformed(null);
    }

    @Nonnull
    public String getReplaceText() {
        return this.textToReplaceTextField.getText();
    }

    public void setReplaceText(String text) {
        this.textToReplaceTextField.setText(text);
    }
}

