/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.table.AbstractTableModel;

@ParametersAreNonnullByDefault
public class EncodingsTableModel
extends AbstractTableModel {
    private final Map<String, EncodingRecord> encodings = new HashMap<String, EncodingRecord>();
    private final List<String> filtered = new ArrayList<String>();
    private final Set<String> usedEncodings = new HashSet<String>();
    private String nameFilter = "";
    private String countryFilter = "";

    public EncodingsTableModel() {
        this.initEncodings();
    }

    private void initEncodings() {
        Charset.availableCharsets().entrySet().stream().map(entry -> (Charset)entry.getValue()).forEachOrdered(charset -> {
            EncodingRecord record = new EncodingRecord();
            record.name = charset.name();
            try {
                record.maxBytes = (int)charset.newEncoder().maxBytesPerChar();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.encodings.put(charset.name().toLowerCase(), record);
        });
        try (InputStream stream = this.getClass().getResourceAsStream("/org/exbin/framework/editor/text/resources/encodingsMap.txt");){
            String encoding;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            do {
                if ((encoding = reader.readLine()) == null) continue;
                EncodingRecord record = this.encodings.get(encoding.toLowerCase());
                if (record != null) {
                    record.description = reader.readLine();
                    record.countries = reader.readLine();
                    continue;
                }
                reader.readLine();
                reader.readLine();
            } while (encoding != null);
        }
        catch (IOException ex) {
            Logger.getLogger(EncodingsTableModel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    @Nullable
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Description";
            }
            case 2: {
                return "Country Codes";
            }
            case 3: {
                return "Max Bytes";
            }
        }
        return null;
    }

    private void rebuildFiltered() {
        this.filtered.clear();
        this.encodings.entrySet().forEach(record -> {
            String name = (String)record.getKey();
            if (!this.usedEncodings.contains(name) && (this.nameFilter.isEmpty() || name.contains(this.nameFilter.toLowerCase())) && (this.countryFilter.isEmpty() || ((EncodingRecord)record.getValue()).countries != null && ((EncodingRecord)record.getValue()).countries.toLowerCase().contains(this.countryFilter.toLowerCase()))) {
                this.filtered.add(name);
            }
        });
        Collections.sort(this.filtered);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.filtered.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        String name = this.filtered.get(rowIndex);
        EncodingRecord record = this.encodings.get(name);
        switch (columnIndex) {
            case 0: {
                return record.name;
            }
            case 1: {
                return record.description;
            }
            case 2: {
                return record.countries;
            }
            case 3: {
                return record.maxBytes;
            }
        }
        return null;
    }

    public void setUsedEncodings(List<String> encodings) {
        this.usedEncodings.clear();
        encodings.forEach(name -> this.usedEncodings.add(name.toLowerCase()));
        this.rebuildFiltered();
    }

    public void setNameFilter(String nameFilter) {
        this.nameFilter = nameFilter;
        this.rebuildFiltered();
    }

    public void setCountryFilter(String countryFilter) {
        this.countryFilter = countryFilter;
        this.rebuildFiltered();
    }

    private static class EncodingRecord {
        String name;
        String description;
        String countries;
        int maxBytes;

        private EncodingRecord() {
        }
    }
}

