/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.exbin.framework.editor.text.gui.EncodingsTableModel;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;

@ParametersAreNonnullByDefault
public class AddEncodingPanel
extends JPanel {
    private final ResourceBundle resourceBundle = LanguageUtils.getResourceBundleByClass(AddEncodingPanel.class);
    private final EncodingsTableModel tableModel = new EncodingsTableModel();
    private JButton clearButton;
    private JLabel countryLabel;
    private JTextField countryTextField;
    private JTable encodingsTable;
    private JScrollPane encodinsScrollPane;
    private JPanel filterPanel;
    private JPanel mainPanel;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel supportedEncodingsLabel;

    public AddEncodingPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.encodingsTable.setModel(this.tableModel);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.nameTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.nameTextChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.nameTextChanged();
            }

            private void nameTextChanged() {
                AddEncodingPanel.this.tableModel.setNameFilter(AddEncodingPanel.this.nameTextField.getText());
            }
        });
        this.countryTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.countryTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.countryTextChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.countryTextChanged();
            }

            private void countryTextChanged() {
                AddEncodingPanel.this.tableModel.setCountryFilter(AddEncodingPanel.this.countryTextField.getText());
            }
        });
    }

    private void initComponents() {
        this.filterPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.countryLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.clearButton = new JButton();
        this.countryTextField = new JTextField();
        this.mainPanel = new JPanel();
        this.supportedEncodingsLabel = new JLabel();
        this.encodinsScrollPane = new JScrollPane();
        this.encodingsTable = new JTable();
        this.setLayout(new BorderLayout());
        this.filterPanel.setBorder(BorderFactory.createTitledBorder(this.resourceBundle.getString("filterPanel.title")));
        this.nameLabel.setText(this.resourceBundle.getString("nameLabel.text"));
        this.countryLabel.setText(this.resourceBundle.getString("countryLabel.text"));
        this.clearButton.setText(this.resourceBundle.getString("clearButton.text"));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddEncodingPanel.this.clearButtonActionPerformed(evt);
            }
        });
        GroupLayout filterPanelLayout = new GroupLayout(this.filterPanel);
        this.filterPanel.setLayout(filterPanelLayout);
        filterPanelLayout.setHorizontalGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addContainerGap().addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addComponent(this.nameLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.nameTextField, -1, 145, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.countryLabel).addGroup(filterPanelLayout.createSequentialGroup().addComponent(this.countryTextField, -2, 118, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearButton, -2, 99, -2))).addContainerGap()));
        filterPanelLayout.setVerticalGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.countryLabel).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.countryTextField, -2, -1, -2).addComponent(this.clearButton).addComponent(this.nameTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.filterPanel, "First");
        this.supportedEncodingsLabel.setText(this.resourceBundle.getString("supportedEncodingsLabel.text"));
        this.encodinsScrollPane.setViewportView(this.encodingsTable);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.encodinsScrollPane, -1, 388, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.supportedEncodingsLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.supportedEncodingsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.encodinsScrollPane, -1, 181, Short.MAX_VALUE).addContainerGap()));
        this.add((Component)this.mainPanel, "Center");
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.nameTextField.setText("");
        this.countryTextField.setText("");
    }

    public void setUsedEncodings(List<String> encodings) {
        this.tableModel.setUsedEncodings(encodings);
    }

    @Nonnull
    public List<String> getEncodings() {
        int[] selectedValues;
        ArrayList<String> result = new ArrayList<String>();
        for (int rowIndex : selectedValues = this.encodingsTable.getSelectedRows()) {
            String value = (String)this.tableModel.getValueAt(rowIndex, 0);
            result.add(value);
        }
        return result;
    }

    @Nonnull
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void main(String[] args) {
        WindowUtils.invokeDialog((JComponent)new AddEncodingPanel());
    }
}

