/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.framework.editor.text;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import org.exbin.framework.api.XBApplication;
import org.exbin.framework.editor.text.TextEncodingStatusApi;
import org.exbin.framework.editor.text.gui.AddEncodingPanel;
import org.exbin.framework.editor.text.options.gui.TextEncodingPanel;
import org.exbin.framework.editor.text.preferences.TextEncodingPreferences;
import org.exbin.framework.editor.text.service.TextEncodingService;
import org.exbin.framework.editor.text.service.impl.TextEncodingServiceImpl;
import org.exbin.framework.frame.api.FrameModuleApi;
import org.exbin.framework.utils.ActionUtils;
import org.exbin.framework.utils.LanguageUtils;
import org.exbin.framework.utils.WindowUtils;
import org.exbin.framework.utils.gui.DefaultControlPanel;
import org.exbin.framework.utils.gui.OptionsControlPanel;
import org.exbin.framework.utils.handler.DefaultControlHandler;
import org.exbin.framework.utils.handler.OptionsControlHandler;

@ParametersAreNonnullByDefault
public class EncodingsHandler {
    public static final String MANAGE_ENCODINGS_ACTION_ID = "manageEncodingsAction";
    private final ResourceBundle resourceBundle;
    private ActionListener encodingActionListener;
    private ButtonGroup encodingButtonGroup;
    private JMenu toolsEncodingMenu;
    private JRadioButtonMenuItem utfEncodingRadioButtonMenuItem;
    private ActionListener utfEncodingActionListener;
    private Component parentComponent = null;
    private Action manageEncodingsAction;
    private TextEncodingPreferences preferences;
    private final TextEncodingService textEncodingService = new TextEncodingServiceImpl();
    private XBApplication application;

    public EncodingsHandler() {
        this.resourceBundle = LanguageUtils.getResourceBundleByClass(EncodingsHandler.class);
    }

    public void setApplication(XBApplication application) {
        this.application = application;
    }

    public void init() {
        this.encodingButtonGroup = new ButtonGroup();
        this.encodingActionListener = e -> this.textEncodingService.setSelectedEncoding(((JRadioButtonMenuItem)e.getSource()).getText());
        this.utfEncodingRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.utfEncodingRadioButtonMenuItem.setSelected(true);
        this.utfEncodingRadioButtonMenuItem.setText(this.resourceBundle.getString("defaultEncoding.text"));
        this.utfEncodingRadioButtonMenuItem.setToolTipText(MessageFormat.format(this.resourceBundle.getString("switchEncoding.toolTipText"), "UTF-8"));
        this.utfEncodingActionListener = evt -> this.textEncodingService.setSelectedEncoding("UTF-8");
        this.utfEncodingRadioButtonMenuItem.addActionListener(this.utfEncodingActionListener);
        this.encodingButtonGroup.add(this.utfEncodingRadioButtonMenuItem);
        this.manageEncodingsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameModuleApi frameModule = (FrameModuleApi)EncodingsHandler.this.application.getModuleRepository().getModuleByInterface(FrameModuleApi.class);
                TextEncodingPanel textEncodingPanel = new TextEncodingPanel();
                textEncodingPanel.setPreferredSize(new Dimension(536, 358));
                textEncodingPanel.setEncodingList(EncodingsHandler.this.textEncodingService.getEncodings());
                OptionsControlPanel optionsControlPanel = new OptionsControlPanel();
                JPanel dialogPanel = WindowUtils.createDialogPanel((JComponent)textEncodingPanel, (JPanel)optionsControlPanel);
                WindowUtils.DialogWrapper dialog = frameModule.createDialog((JComponent)dialogPanel, (JPanel)optionsControlPanel);
                WindowUtils.addHeaderPanel((Window)dialog.getWindow(), textEncodingPanel.getClass(), (ResourceBundle)textEncodingPanel.getResourceBundle());
                frameModule.setDialogTitle(dialog, textEncodingPanel.getResourceBundle());
                optionsControlPanel.setHandler(actionType -> {
                    if (actionType != OptionsControlHandler.ControlActionType.CANCEL) {
                        EncodingsHandler.this.textEncodingService.setEncodings(textEncodingPanel.getEncodingList());
                        EncodingsHandler.this.rebuildEncodings();
                        if (actionType == OptionsControlHandler.ControlActionType.SAVE) {
                            EncodingsHandler.this.preferences.setEncodings(textEncodingPanel.getEncodingList());
                        }
                    }
                    dialog.close();
                    dialog.dispose();
                });
                textEncodingPanel.setAddEncodingsOperation(usedEncodings -> {
                    ArrayList result = new ArrayList();
                    AddEncodingPanel addEncodingPanel = new AddEncodingPanel();
                    addEncodingPanel.setUsedEncodings(usedEncodings);
                    DefaultControlPanel encodingsControlPanel = new DefaultControlPanel(addEncodingPanel.getResourceBundle());
                    WindowUtils.DialogWrapper addEncodingDialog = frameModule.createDialog((JComponent)addEncodingPanel, (JPanel)encodingsControlPanel);
                    WindowUtils.addHeaderPanel((Window)addEncodingDialog.getWindow(), addEncodingPanel.getClass(), (ResourceBundle)addEncodingPanel.getResourceBundle());
                    frameModule.setDialogTitle(addEncodingDialog, addEncodingPanel.getResourceBundle());
                    encodingsControlPanel.setHandler(actionType -> {
                        if (actionType == DefaultControlHandler.ControlActionType.OK) {
                            result.addAll(addEncodingPanel.getEncodings());
                        }
                        addEncodingDialog.close();
                        addEncodingDialog.dispose();
                    });
                    addEncodingDialog.showCentered((Component)addEncodingPanel);
                    return result;
                });
                dialog.showCentered(EncodingsHandler.this.parentComponent);
            }
        };
        ActionUtils.setupAction((Action)this.manageEncodingsAction, (ResourceBundle)this.resourceBundle, (String)MANAGE_ENCODINGS_ACTION_ID);
        this.manageEncodingsAction.putValue("dialogMode", true);
        this.toolsEncodingMenu = new JMenu();
        this.toolsEncodingMenu.addSeparator();
        this.toolsEncodingMenu.add(ActionUtils.actionToMenuItem((Action)this.manageEncodingsAction));
        this.toolsEncodingMenu.setText(this.resourceBundle.getString("toolsEncodingMenu.text"));
        this.toolsEncodingMenu.setToolTipText(this.resourceBundle.getString("toolsEncodingMenu.shortDescription"));
        this.rebuildEncodings();
    }

    public void setTextEncodingStatus(TextEncodingStatusApi textEncodingStatus) {
        this.textEncodingService.setTextEncodingStatus(textEncodingStatus);
    }

    public void setEncodingChangeListener(TextEncodingService.EncodingChangeListener listener) {
        this.textEncodingService.setEncodingChangeListener(listener);
    }

    @Nonnull
    public String getSelectedEncoding() {
        return this.textEncodingService.getSelectedEncoding();
    }

    public void setSelectedEncoding(String encoding) {
        this.textEncodingService.setSelectedEncoding(encoding);
    }

    @Nonnull
    public TextEncodingService getTextEncodingService() {
        return this.textEncodingService;
    }

    @Nonnull
    public JMenu getToolsEncodingMenu() {
        return this.toolsEncodingMenu;
    }

    public void rebuildEncodings() {
        for (int i = this.toolsEncodingMenu.getItemCount() - 3; i >= 0; --i) {
            this.encodingButtonGroup.remove(this.toolsEncodingMenu.getItem(i));
            this.toolsEncodingMenu.remove(i);
        }
        List<String> encodings = this.textEncodingService.getEncodings();
        if (encodings.isEmpty()) {
            this.toolsEncodingMenu.add((Component)this.utfEncodingRadioButtonMenuItem, 0);
            this.textEncodingService.setSelectedEncoding("UTF-8");
            this.utfEncodingRadioButtonMenuItem.setSelected(true);
        } else {
            int selectedEncodingIndex = encodings.indexOf(this.textEncodingService.getSelectedEncoding());
            for (int index = 0; index < encodings.size(); ++index) {
                String encoding = encodings.get(index);
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(encoding);
                item.addActionListener(this.encodingActionListener);
                item.setToolTipText(MessageFormat.format(this.resourceBundle.getString("switchEncoding.toolTipText"), encoding));
                this.toolsEncodingMenu.add((Component)item, index);
                this.encodingButtonGroup.add(item);
                if (index != selectedEncodingIndex) continue;
                item.setSelected(true);
            }
        }
    }

    private void updateEncodingsSelection(int menuIndex) {
        if (menuIndex > 0) {
            ++menuIndex;
        }
        JMenuItem item = this.toolsEncodingMenu.getItem(menuIndex);
        item.setSelected(true);
    }

    public void loadFromPreferences(TextEncodingPreferences preferences) {
        this.preferences = preferences;
        this.textEncodingService.loadFromPreferences(preferences);
        this.rebuildEncodings();
    }

    public void cycleEncodings() {
        int menuIndex = 0;
        List<String> encodings = this.textEncodingService.getEncodings();
        if (!encodings.isEmpty()) {
            int selectedEncodingIndex = encodings.indexOf(this.textEncodingService.getSelectedEncoding());
            if (selectedEncodingIndex < 0 || selectedEncodingIndex == encodings.size() - 1) {
                this.textEncodingService.setSelectedEncoding(encodings.get(0));
            } else {
                this.textEncodingService.setSelectedEncoding(encodings.get(selectedEncodingIndex + 1));
                menuIndex = selectedEncodingIndex;
            }
        }
        this.updateEncodingsSelection(menuIndex);
    }

    public void popupEncodingsMenu(MouseEvent mouseEvent) {
        JPopupMenu popupMenu = new JPopupMenu();
        List<String> encodings = this.textEncodingService.getEncodings();
        String selectedEncoding = this.textEncodingService.getSelectedEncoding();
        if (encodings.isEmpty()) {
            JRadioButtonMenuItem utfEncoding = new JRadioButtonMenuItem(this.resourceBundle.getString("defaultEncoding.text"), "UTF-8".equals(selectedEncoding));
            utfEncoding.setToolTipText(MessageFormat.format(this.resourceBundle.getString("switchEncoding.toolTipText"), "UTF-8"));
            utfEncoding.addActionListener(this.utfEncodingActionListener);
            popupMenu.add(utfEncoding);
        } else {
            int selectedEncodingIndex = encodings.indexOf(selectedEncoding);
            for (int index = 0; index < encodings.size(); ++index) {
                String encoding = encodings.get(index);
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(encoding, index == selectedEncodingIndex);
                item.addActionListener(this.encodingActionListener);
                item.setToolTipText(MessageFormat.format(this.resourceBundle.getString("switchEncoding.toolTipText"), encoding));
                popupMenu.add((Component)item, index);
            }
        }
        popupMenu.add(new JSeparator());
        popupMenu.add(ActionUtils.actionToMenuItem((Action)this.manageEncodingsAction));
        popupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void setEncodings(List<String> encodings) {
        this.textEncodingService.setEncodings(encodings);
    }

    public void setParentComponent(Component component) {
        this.parentComponent = component;
    }
}

